/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ddl;

import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlConstants;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseIndexMember;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class SybaseDdlUtils
implements IGenericDdlConstants,
ISybaseDdlConstants {
    public static String getSQLObjectName(SQLObject obj, boolean quoteIdentifiers, boolean qualifyNames) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Table) {
            return SybaseDdlUtils.getSQLObjectName((SQLObject)((Table)obj), quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof Routine) {
            return SybaseDdlUtils.getSQLObjectName((SQLObject)((Routine)obj), quoteIdentifiers, qualifyNames);
        }
        if (obj instanceof SQLObject) {
            if (quoteIdentifiers) {
                return SQLUtil.quote(obj.getName(), "\"");
            }
            return obj.getName();
        }
        return "";
    }

    public static String getIndexMemberKeys(EList members, boolean quoteIdentifiers) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < members.size()) {
            IndexMember m = (IndexMember)members.get(i);
            if (i == 0) {
                result.append(SybaseDdlUtils.getIndexMember(quoteIdentifiers, m, false));
            } else {
                result.append(SybaseDdlUtils.getIndexMember(quoteIdentifiers, m, true));
            }
            ++i;
        }
        return result.toString();
    }

    public static String getIndexMember(boolean quoteIdentifiers, IndexMember member, boolean hasComma) {
        StringBuffer result = new StringBuffer("");
        if (hasComma) {
            result.append(" , ");
        }
        if (member instanceof SybaseIndexMember) {
            if (member.getName() == null) {
                result.append(((SybaseIndexMember)member).getColumnExpression());
            } else {
                result.append(String.valueOf(((SybaseIndexMember)member).getColumnExpression()) + " " + "AS" + " " + member.getName());
            }
        } else if (member.getColumn() != null) {
            if (quoteIdentifiers) {
                result.append(SQLUtil.quote(member.getColumn().getName(), "\""));
            } else {
                result.append(member.getColumn().getName());
            }
        }
        if (member instanceof SybaseIndexMember && member.getName() != null) {
            return result.toString();
        }
        result.append(" " + member.getIncrementType().getName());
        return result.toString();
    }

    public static boolean isEqualIndexMembers(Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return true;
        }
        if (newValue instanceof EList && ((EList)newValue).size() > 0 && ((EList)newValue).get(0) instanceof IndexMember) {
            EList newList = (EList)newValue;
            EList oldList = (EList)oldValue;
            if (SybaseDdlUtils.getIndexMemberKeys(newList, true).equals(SybaseDdlUtils.getIndexMemberKeys(oldList, true))) {
                return true;
            }
        }
        if (newValue != null) {
            return newValue.equals(oldValue);
        }
        return newValue == oldValue;
    }
}

