/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointChange;

public abstract class LineBreakpointChange
extends BreakpointChange {
    private final int fCharEnd;
    private final int fCharStart;
    private final int fLineNumber;
    private boolean fConditionEnabled;
    private boolean fConditionSuspendOnTrue;
    private String fCondition;

    public LineBreakpointChange(IJavaLineBreakpoint breakpoint) throws CoreException {
        super((IJavaBreakpoint)breakpoint);
        this.fCharEnd = breakpoint.getCharEnd();
        this.fCharStart = breakpoint.getCharStart();
        this.fLineNumber = breakpoint.getLineNumber();
        if (breakpoint.supportsCondition()) {
            this.fCondition = breakpoint.getCondition();
            this.fConditionEnabled = breakpoint.isConditionEnabled();
            this.fConditionSuspendOnTrue = breakpoint.isConditionSuspendOnTrue();
        }
    }

    protected void apply(IJavaLineBreakpoint breakpoint) throws CoreException {
        super.apply((IJavaBreakpoint)breakpoint);
        if (breakpoint.supportsCondition()) {
            breakpoint.setCondition(this.fCondition);
            breakpoint.setConditionEnabled(this.fConditionEnabled);
            breakpoint.setConditionSuspendOnTrue(this.fConditionSuspendOnTrue);
        }
    }

    @Override
    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected int getCharEnd() {
        return this.fCharEnd;
    }

    protected int getCharStart() {
        return this.fCharStart;
    }
}

