/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractProductContentSection<S extends AbstractProductContentSection<S>>
extends TableSection {
    private final Predicate<Object> elementFilter;
    private final List<Consumer<S>> buttonHandlers;

    protected AbstractProductContentSection(PDEFormPage formPage, Composite parent, List<String> buttonLabels, List<Consumer<S>> buttonHandlers, Predicate<Object> elementFilter) {
        super(formPage, parent, 128, (String[])buttonLabels.toArray(String[]::new));
        this.elementFilter = elementFilter;
        this.buttonHandlers = buttonHandlers;
    }

    TableViewer getTableViewer() {
        return this.getTablePart().getTableViewer();
    }

    Table getTable() {
        return this.getTableViewer().getTable();
    }

    IStructuredSelection getTableSelection() {
        return this.getTableViewer().getStructuredSelection();
    }

    IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    IProduct getProduct() {
        return this.getModel().getProduct();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData data = (GridData)this.getTablePart().getControl().getLayoutData();
        data.minimumWidth = 200;
        this.populateSection(section, container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.createSectionToolbar(section);
    }

    abstract void populateSection(Section var1, Composite var2, FormToolkit var3);

    void createAutoIncludeRequirementsButton(Composite container, String buttonLabel) {
        Button autoInclude = new Button(container, 32);
        autoInclude.setText(buttonLabel);
        autoInclude.setSelection(this.getProduct().includeRequirementsAutomatically());
        if (this.isEditable()) {
            autoInclude.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.getProduct().setIncludeRequirementsAutomatically(autoInclude.getSelection())));
        } else {
            autoInclude.setEnabled(false);
        }
    }

    <T> void configureTable(Function<IProduct, T[]> provider, ViewerComparator comparator) {
        TableViewer fTable = this.getTableViewer();
        fTable.setContentProvider((IContentProvider)((IStructuredContentProvider)p -> (Object[])provider.apply((IProduct)p)));
        fTable.setComparator(comparator);
        fTable.setInput((Object)this.getProduct());
    }

    void enableTableButtons(int ... buttonIndices) {
        EditableTablePart tablePart = this.getTablePart();
        int[] nArray = buttonIndices;
        int n = buttonIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int button = nArray[n2];
            tablePart.setButtonEnabled(button, this.isEditable());
            ++n2;
        }
    }

    private void createSectionToolbar(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        toolbar.setCursor(Display.getCurrent().getSystemCursor(21));
        this.getToolbarActions().forEach(arg_0 -> ((ToolBarManager)toolBarManager).add(arg_0));
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    abstract List<Action> getToolbarActions();

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection ssel = this.getTableSelection();
        if (ssel == null) {
            return;
        }
        Action openAction = AbstractProductContentSection.createAction(PDEUIMessages.PluginSection_open, () -> this.handleDoubleClick(this.getTableSelection()));
        openAction.setEnabled(this.isEditable() && ssel.size() == 1);
        manager.add((IAction)openAction);
        manager.add((IContributionItem)new Separator());
        Action removeAction = AbstractProductContentSection.createAction(PDEUIMessages.PluginSection_remove, this::handleRemove);
        removeAction.setEnabled(this.isEditable() && !ssel.isEmpty());
        manager.add((IAction)removeAction);
        Action removeAll = AbstractProductContentSection.createAction(PDEUIMessages.PluginSection_removeAll, this::handleRemoveAll);
        removeAll.setEnabled(this.isEditable());
        manager.add((IAction)removeAll);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean setFormInput(Object input) {
        if (this.elementFilter.test(input)) {
            this.getTableViewer().setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        return Stream.of(objects).anyMatch(this.elementFilter);
    }

    @Override
    protected void buttonSelected(int index) {
        if (index < this.buttonHandlers.size()) {
            this.buttonHandlers.get(index).accept(this);
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IProductFeature) {
            IProductFeature feature = (IProductFeature)element;
            FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel model = fmm.findFeatureModel(feature.getId(), feature.getVersion());
            FeatureEditor.openFeatureEditor(model);
        } else if (element instanceof IProductPlugin) {
            IProductPlugin plugin = (IProductPlugin)element;
            ManifestEditor.openPluginEditor(plugin.getId());
        }
    }

    void handleRemove() {
        IStructuredSelection ssel = this.getTableSelection();
        if (!ssel.isEmpty()) {
            this.removeElements(this.getProduct(), ssel.toList());
            this.updateButtons(true, true);
        }
    }

    abstract void removeElements(IProduct var1, List<Object> var2);

    abstract void handleRemoveAll();

    public void refresh() {
        this.getTableViewer().refresh();
        this.updateButtons(true, true);
        super.refresh();
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons(true, false);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged();
            return;
        }
        TableViewer tableViewer = this.getTableViewer();
        if (e.getChangeType() == 1) {
            Stream.of(e.getChangedObjects()).filter(this.elementFilter).forEach(arg_0 -> ((TableViewer)tableViewer).add(arg_0));
        } else if (e.getChangeType() == 2) {
            Stream.of(e.getChangedObjects()).filter(this.elementFilter).forEach(arg_0 -> ((TableViewer)tableViewer).remove(arg_0));
            Table table = this.getTable();
            int count = table.getItemCount();
            if (count != 0) {
                int index = table.getSelectionIndex();
                table.setSelection(Math.min(index, count - 1));
            }
        } else if (e.getChangeType() == 3) {
            tableViewer.refresh();
        }
        this.updateButtons(false, true);
    }

    private void handleModelEventWorldChanged() {
        if (this.getTable().isDisposed()) {
            return;
        }
        this.getTableViewer().setInput((Object)this.getProduct());
        this.refresh();
    }

    abstract void updateButtons(boolean var1, boolean var2);

    void updateRemoveButtons(int btnRemove, int btnRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        if (btnRemove > -1) {
            IStructuredSelection structuredSelection;
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(btnRemove, this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection && this.elementFilter.test((structuredSelection = selection).getFirstElement()));
        }
        if (btnRemoveAll > -1) {
            tablePart.setButtonEnabled(btnRemoveAll, this.isEditable() && tablePart.getTableViewer().getTable().getItemCount() > 0);
        }
    }

    static Action createPushAction(String text, ImageDescriptor image, Runnable runAction) {
        Action action = AbstractProductContentSection.createAction(text, 1, runAction);
        action.setImageDescriptor(image);
        return action;
    }

    static Action createAction(String text, Runnable action) {
        return AbstractProductContentSection.createAction(text, 0, action);
    }

    static <S> int addButton(String label, Consumer<S> handler, List<String> labels, List<Consumer<S>> handlers) {
        labels.add(label);
        handlers.add(handler);
        return labels.size() - 1;
    }

    private static Action createAction(String text, int style, final Runnable action) {
        return new Action(text, style){

            public void run() {
                action.run();
            }
        };
    }

    static <T> T[] filterToArray(Stream<Object> stream, Class<T> type) {
        return stream.filter(type::isInstance).map(type::cast).toArray(l -> (Object[])Array.newInstance(type, l));
    }
}

