/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.CommitComment;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.MergeStatus;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class PullRequestService
extends GitHubService {
    public static final String PR_TITLE = "title";
    public static final String PR_BODY = "body";
    public static final String PR_BASE = "base";
    public static final String PR_HEAD = "head";
    public static final String PR_STATE = "state";

    public PullRequestService() {
    }

    public PullRequestService(GitHubClient client) {
        super(client);
    }

    public PullRequest getPullRequest(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)PullRequest.class));
        return (PullRequest)this.client.get(request).getBody();
    }

    protected PagedRequest<PullRequest> createPullsRequest(IRepositoryIdProvider provider, String state, int start, int size) {
        String id = this.getId(provider);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        PagedRequest<PullRequest> request = this.createPagedRequest(start, size);
        request.setUri(uri);
        if (state != null) {
            request.setParams(Collections.singletonMap(PR_STATE, state));
        }
        request.setType(new TypeToken<List<PullRequest>>(){}.getType());
        return request;
    }

    public List<PullRequest> getPullRequests(IRepositoryIdProvider repository, String state) throws IOException {
        return this.getAll(this.pagePullRequests(repository, state));
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state) {
        return this.pagePullRequests(repository, state, 100);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, int size) {
        return this.pagePullRequests(repository, state, 1, size);
    }

    public PageIterator<PullRequest> pagePullRequests(IRepositoryIdProvider repository, String state, int start, int size) {
        PagedRequest<PullRequest> request = this.createPullsRequest(repository, state, start, size);
        return this.createPageIterator(request);
    }

    private Map<String, String> createPrMap(PullRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request != null) {
            String head;
            PullRequestMarker headMarker;
            String base;
            PullRequestMarker baseMarker;
            String body;
            String title = request.getTitle();
            if (title != null) {
                params.put(PR_TITLE, title);
            }
            if ((body = request.getBody()) != null) {
                params.put(PR_BODY, body);
            }
            if ((baseMarker = request.getBase()) != null && (base = baseMarker.getLabel()) != null) {
                params.put(PR_BASE, base);
            }
            if ((headMarker = request.getHead()) != null && (head = headMarker.getLabel()) != null) {
                params.put(PR_HEAD, head);
            }
        }
        return params;
    }

    private Map<String, String> editPrMap(PullRequest request) {
        String state;
        String body;
        HashMap<String, String> params = new HashMap<String, String>();
        String title = request.getTitle();
        if (title != null) {
            params.put(PR_TITLE, title);
        }
        if ((body = request.getBody()) != null) {
            params.put(PR_BODY, body);
        }
        if ((state = request.getState()) != null) {
            params.put(PR_STATE, state);
        }
        return params;
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, PullRequest request) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        Map<String, String> params = this.createPrMap(request);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public PullRequest createPullRequest(IRepositoryIdProvider repository, int issueId, String head, String base) throws IOException {
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("issue", issueId);
        params.put(PR_HEAD, head);
        params.put(PR_BASE, base);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public PullRequest editPullRequest(IRepositoryIdProvider repository, PullRequest request) throws IOException {
        String id = this.getId(repository);
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        uri.append('/').append(request.getNumber());
        Map<String, String> params = this.editPrMap(request);
        return (PullRequest)this.client.post(uri.toString(), params, (Type)((Object)PullRequest.class));
    }

    public List<RepositoryCommit> getCommits(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/commits");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<RepositoryCommit>>(){}.getType());
        return this.getAll(request);
    }

    public List<CommitFile> getFiles(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/files");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitFile>>(){}.getType());
        return this.getAll(request);
    }

    public boolean isMerged(IRepositoryIdProvider repository, int id) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/merge");
        return this.check(uri.toString());
    }

    public MergeStatus merge(IRepositoryIdProvider repository, int id, String commitMessage) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/merge");
        return (MergeStatus)this.client.put(uri.toString(), Collections.singletonMap("commit_message", commitMessage), (Type)((Object)MergeStatus.class));
    }

    public List<CommitComment> getComments(IRepositoryIdProvider repository, int id) throws IOException {
        return this.getAll(this.pageComments(repository, id));
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id) {
        return this.pageComments(repository, id, 100);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id, int size) {
        return this.pageComments(repository, id, 1, size);
    }

    public PageIterator<CommitComment> pageComments(IRepositoryIdProvider repository, int id, int start, int size) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<CommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }

    public CommitComment getComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)CommitComment.class));
        return (CommitComment)this.client.get(request).getBody();
    }

    public CommitComment createComment(IRepositoryIdProvider repository, int id, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public CommitComment replyToComment(IRepositoryIdProvider repository, int pullRequestId, int commentId, String body) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(pullRequestId);
        uri.append("/comments");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("in_reply_to", Integer.toString(commentId));
        params.put(PR_BODY, body);
        return (CommitComment)this.client.post(uri.toString(), params, (Type)((Object)CommitComment.class));
    }

    public CommitComment editComment(IRepositoryIdProvider repository, CommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        if (comment == null) {
            throw new IllegalArgumentException("Comment cannot be null");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (CommitComment)this.client.post(uri.toString(), comment, (Type)((Object)CommitComment.class));
    }

    public void deleteComment(IRepositoryIdProvider repository, long commentId) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(commentId);
        this.client.delete(uri.toString());
    }
}

