/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ToggleableWarningLabel
extends Composite {
    private Label warningText;
    private Label image;
    private boolean isBuiltInImage;

    public ToggleableWarningLabel(Composite parent, int style) {
        super(parent, style);
        this.setVisible(false);
        this.setLayout((Layout)new GridLayout(2, false));
        this.image = new Label((Composite)this, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.image);
        this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.isBuiltInImage = true;
        this.warningText = new Label((Composite)this, 64);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.warningText);
    }

    public boolean showMessage(String message) {
        boolean changed = false;
        if (!this.isBuiltInImage) {
            this.image.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            this.isBuiltInImage = true;
            changed = true;
        }
        return changed |= this.setText(message);
    }

    public boolean hideMessage() {
        return this.changeVisibility(false);
    }

    protected void setImage(Image image) {
        this.image.setImage(image);
        this.isBuiltInImage = false;
    }

    protected boolean setText(String message) {
        boolean changed = false;
        if (!Objects.equals(message, this.warningText.getText())) {
            this.warningText.setText(message);
            changed = true;
        }
        return changed |= this.changeVisibility(true);
    }

    protected boolean changeVisibility(boolean visible) {
        if (visible != this.getVisible()) {
            this.setVisible(visible);
            GridData data = (GridData)this.getLayoutData();
            data.exclude = !visible;
            return true;
        }
        return false;
    }
}

