/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.Function;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;

class StringToJavaTimeConverter
implements StringToObjectConverter {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS = Map.ofEntries(Map.entry(Duration.class, Duration::parse), Map.entry(Instant.class, Instant::parse), Map.entry(LocalDate.class, LocalDate::parse), Map.entry(LocalDateTime.class, LocalDateTime::parse), Map.entry(LocalTime.class, LocalTime::parse), Map.entry(MonthDay.class, MonthDay::parse), Map.entry(OffsetDateTime.class, OffsetDateTime::parse), Map.entry(OffsetTime.class, OffsetTime::parse), Map.entry(Period.class, Period::parse), Map.entry(Year.class, Year::parse), Map.entry(YearMonth.class, YearMonth::parse), Map.entry(ZonedDateTime.class, ZonedDateTime::parse), Map.entry(ZoneId.class, ZoneId::of), Map.entry(ZoneOffset.class, ZoneOffset::of));

    StringToJavaTimeConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return CONVERTERS.containsKey(targetType);
    }

    @Override
    public Object convert(String source, Class<?> targetType) throws Exception {
        Function<String, ?> converter = Preconditions.notNull(CONVERTERS.get(targetType), () -> "No registered converter for %s".formatted(targetType.getName()));
        return converter.apply(source);
    }
}

