/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.extension.PreInterruptCallbackInvocation;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutExceptionFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class SameThreadTimeoutInvocation<T>
implements InvocationInterceptor.Invocation<T> {
    private final InvocationInterceptor.Invocation<T> delegate;
    private final TimeoutDuration timeout;
    private final ScheduledExecutorService executor;
    private final Supplier<String> descriptionSupplier;
    private final PreInterruptCallbackInvocation preInterruptCallback;

    SameThreadTimeoutInvocation(InvocationInterceptor.Invocation<T> delegate, TimeoutDuration timeout, ScheduledExecutorService executor, Supplier<String> descriptionSupplier, PreInterruptCallbackInvocation preInterruptCallback) {
        this.delegate = delegate;
        this.timeout = timeout;
        this.executor = executor;
        this.descriptionSupplier = descriptionSupplier;
        this.preInterruptCallback = preInterruptCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T proceed() throws Throwable {
        InterruptTask interruptTask = new InterruptTask(Thread.currentThread(), this.preInterruptCallback);
        ScheduledFuture<?> future = this.executor.schedule(interruptTask, this.timeout.value(), this.timeout.unit());
        Throwable failure = null;
        Object result = null;
        try {
            result = this.delegate.proceed();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            failure = t;
        }
        finally {
            boolean cancelled = future.cancel(false);
            if (!cancelled) {
                future.get();
            }
            if (interruptTask.executed) {
                Thread.interrupted();
                failure = TimeoutExceptionFactory.create(this.descriptionSupplier.get(), this.timeout, failure);
                interruptTask.attachSuppressedExceptions(failure);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return (T)result;
    }

    static class InterruptTask
    implements Runnable {
        private final PreInterruptCallbackInvocation preInterruptCallback;
        private final List<Throwable> exceptionsDuringInterruption = new CopyOnWriteArrayList<Throwable>();
        private final Thread thread;
        private volatile boolean executed;

        InterruptTask(Thread thread, PreInterruptCallbackInvocation preInterruptCallback) {
            this.thread = thread;
            this.preInterruptCallback = preInterruptCallback;
        }

        @Override
        public void run() {
            this.executed = true;
            this.preInterruptCallback.executePreInterruptCallback(this.thread, this.exceptionsDuringInterruption::add);
            this.thread.interrupt();
        }

        void attachSuppressedExceptions(Throwable outerException) {
            for (Throwable throwable : this.exceptionsDuringInterruption) {
                outerException.addSuppressed(throwable);
            }
        }
    }
}

