/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.junit.jupiter.engine.support.MethodReflectionUtils;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

abstract class IsTestableMethod
implements Predicate<Method> {
    private final Class<? extends Annotation> annotationType;
    private final DiscoveryIssueReporter.Condition<Method> condition;

    IsTestableMethod(Class<? extends Annotation> annotationType, BiFunction<Class<? extends Annotation>, DiscoveryIssueReporter, DiscoveryIssueReporter.Condition<Method>> returnTypeConditionFactory, DiscoveryIssueReporter issueReporter) {
        this.annotationType = annotationType;
        this.condition = IsTestableMethod.isNotStatic(annotationType, issueReporter).and(IsTestableMethod.isNotPrivate(annotationType, issueReporter)).and(returnTypeConditionFactory.apply(annotationType, issueReporter));
    }

    @Override
    public boolean test(Method candidate) {
        if (!candidate.isSynthetic() && AnnotationSupport.isAnnotated((AnnotatedElement)candidate, this.annotationType)) {
            return this.condition.check((Object)candidate) && ModifierSupport.isNotAbstract((Member)candidate);
        }
        return false;
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotStatic(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotStatic, method -> IsTestableMethod.createIssue(annotationType, method, "must not be static"));
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotPrivate(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotPrivate, method -> IsTestableMethod.createIssue(annotationType, method, "must not be private"));
    }

    protected static DiscoveryIssueReporter.Condition<Method> hasVoidReturnType(Class<? extends Annotation> annotationType, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(method -> MethodReflectionUtils.getReturnType(method) == Void.TYPE, method -> IsTestableMethod.createIssue(annotationType, method, "must not return a value"));
    }

    protected static DiscoveryIssue createIssue(Class<? extends Annotation> annotationType, Method method, String condition) {
        String message = "@%s method '%s' %s. It will not be executed.".formatted(annotationType.getSimpleName(), method.toGenericString(), condition);
        return DiscoveryIssue.builder((DiscoveryIssue.Severity)DiscoveryIssue.Severity.WARNING, (String)message).source((TestSource)MethodSource.from((Method)method)).build();
    }
}

