/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.xsd;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.xsd.XsdComponent;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XsdSchema
extends XsdComponent<XSDSchema> {
    XsdSchema(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public XSDSchema getXSDSchema() {
        return (XSDSchema)this.getXSDComponent();
    }

    public Iterable<String> getNamespaces() {
        Iterable result = IterableTools.cloneSnapshot(this.getXSDSchema().getQNamePrefixToNamespaceMap().values());
        if (StringTools.isBlank((String)this.getXSDSchema().getTargetNamespace())) {
            result = IterableTools.insert((Object)"", (Iterable)result);
        }
        return result;
    }

    public Iterable<XsdTypeDefinition> getAllTypeDefinitions() {
        return IterableTools.transform(this.getAllXSDTypeDefinitions(), XsdUtil.adapterTransformer());
    }

    public Iterable<XsdTypeDefinition> getDeclaredTypeDefinitions() {
        return IterableTools.transform(this.getDeclaredXSDTypeDefinitions(), XsdUtil.adapterTransformer());
    }

    public Iterable<XsdTypeDefinition> getBuiltInTypeDefinitions() {
        return IterableTools.transform(this.getBuiltInXSDTypeDefinitions(), XsdUtil.adapterTransformer());
    }

    public Iterable<XsdTypeDefinition> getTypeDefinitions(String namespace) {
        return IterableTools.transform(this.getXSDTypeDefinitions(namespace), XsdUtil.adapterTransformer());
    }

    public Iterable<XsdSimpleTypeDefinition> getSimpleTypeDefinitions(String namespace) {
        return IterableTools.transform(this.getXSDSimpleTypeDefinitions(namespace), XsdUtil.adapterTransformer());
    }

    public XsdTypeDefinition getTypeDefinition(String name) {
        return this.getTypeDefinition(((XSDSchema)this.getXSDComponent()).getTargetNamespace(), name);
    }

    public XsdTypeDefinition getTypeDefinition(String namespace, String name) {
        for (XSDTypeDefinition typeDefinition : this.getXSDTypeDefinitions(namespace)) {
            if (!XsdUtil.namespaceEquals((XSDNamedComponent)typeDefinition, namespace) || !typeDefinition.getName().equals(name)) continue;
            return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)typeDefinition));
        }
        return null;
    }

    protected Iterable<XSDTypeDefinition> getAllXSDTypeDefinitions() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getDeclaredXSDTypeDefinitions(), this.getBuiltInXSDTypeDefinitions()});
    }

    protected Iterable<XSDTypeDefinition> getDeclaredXSDTypeDefinitions() {
        return IterableTools.cloneSnapshot((List)this.getXSDSchema().getTypeDefinitions());
    }

    protected Iterable<XSDTypeDefinition> getBuiltInXSDTypeDefinitions() {
        return IterableTools.cloneSnapshot((List)this.getXSDSchema().getSchemaForSchema().getTypeDefinitions());
    }

    protected Iterable<XSDTypeDefinition> getXSDTypeDefinitions(String namespace) {
        return "http://www.w3.org/2001/XMLSchema".equals(namespace) ? this.getBuiltInXSDTypeDefinitions() : IterableTools.filter(this.getDeclaredXSDTypeDefinitions(), (Predicate)new XsdUtil.NamespaceEquals(namespace));
    }

    protected Iterable<XSDSimpleTypeDefinition> getXSDSimpleTypeDefinitions(String namespace) {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getXSDTypeDefinitions(namespace), (Predicate)PredicateTools.instanceOf(XSDSimpleTypeDefinition.class)));
    }

    public Iterable<XsdElementDeclaration> getElementDeclarations() {
        return IterableTools.transform(this.getXSDElementDeclarations(), XsdUtil.adapterTransformer());
    }

    public Iterable<XsdElementDeclaration> getElementDeclarations(String namespace) {
        return IterableTools.transform((Iterable)IterableTools.filter(this.getXSDElementDeclarations(), (Predicate)new XsdUtil.NamespaceEquals(namespace)), XsdUtil.adapterTransformer());
    }

    public XsdElementDeclaration getElementDeclaration(String namespace, String name) {
        for (XSDElementDeclaration elementDeclaration : this.getXSDElementDeclarations()) {
            if (!XsdUtil.namespaceEquals((XSDNamedComponent)elementDeclaration, namespace) || !elementDeclaration.getName().equals(name)) continue;
            return (XsdElementDeclaration)((Object)XsdUtil.getAdapter((Notifier)elementDeclaration));
        }
        return null;
    }

    protected Iterable<XSDElementDeclaration> getXSDElementDeclarations() {
        return IterableTools.cloneSnapshot((List)this.getXSDSchema().getElementDeclarations());
    }

    public Iterable<String> getNamespaceProposals() {
        return new TransformationIterable(this.getNamespaces(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    public Iterable<String> getTypeNameProposals(String namespace) {
        return IterableTools.transform((Iterable)IterableTools.transform(this.getTypeDefinitions(namespace), XsdTypeDefinition.NAME_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    public Iterable<String> getSimpleTypeNameProposals(String namespace) {
        return IterableTools.transform((Iterable)IterableTools.transform(this.getSimpleTypeDefinitions(namespace), XsdTypeDefinition.NAME_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    public Iterable<String> getElementNameProposals(String namespace) {
        return IterableTools.transform((Iterable)IterableTools.transform(this.getElementDeclarations(namespace), XsdFeature.NAME_TRANSFORMER), (Transformer)StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }
}

