/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.bcoview.BytecodeOutlinePlugin;
import org.eclipse.jdt.bcoview.asm.CommentedClassVisitor;
import org.eclipse.jdt.bcoview.asm.DecompilerOptions;
import org.eclipse.jdt.bcoview.asm.Index;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.tree.analysis.Value;

public class DecompiledMethod {
    private final List<Object> text;
    private final List<LocalVariableNode> localVariables;
    private final Map<Integer, Integer> sourceLines;
    private final Map<Integer, Integer> decompiledLines;
    private final Map<Integer, Integer> insns;
    private final Map<Integer, Integer> opcodes;
    private final Map<Integer, Integer> insnLines;
    private int lineCount;
    private int firstSourceLine;
    private int lastSourceLine;
    MethodNode meth;
    private Frame<?>[] frames;
    private String error;
    private int errorInsn;
    private final String owner;
    private final Map<Label, Integer> lineNumbers;
    private final DecompilerOptions options;
    private final int access;

    public DecompiledMethod(String owner, Map<Label, Integer> lineNumbers, MethodNode meth, DecompilerOptions options, int access) {
        this.meth = meth;
        this.owner = owner;
        this.lineNumbers = lineNumbers;
        this.options = options;
        this.access = access;
        this.text = new ArrayList<Object>();
        this.localVariables = meth.localVariables;
        this.sourceLines = new HashMap<Integer, Integer>();
        this.decompiledLines = new HashMap<Integer, Integer>();
        this.insns = new HashMap<Integer, Integer>();
        this.opcodes = new HashMap<Integer, Integer>();
        this.insnLines = new HashMap<Integer, Integer>();
    }

    void setText(List<?> inputText) {
        this.formatText(inputText, new HashMap<Integer, String>(), new StringBuffer(), this.text);
        this.computeMaps(this.lineNumbers);
        if (this.options.modes.get(8) && (this.access & 0x400) == 0) {
            this.analyzeMethod();
        }
    }

    void addLineNumber(Label start, Integer integer) {
        this.lineNumbers.put(start, integer);
    }

    public boolean isInit() {
        return "<init>".equals(this.meth.name) && "()V".equals(this.meth.desc) || "<clinit>".equals(this.meth.name);
    }

    public String getSignature() {
        return this.meth.name + this.meth.desc;
    }

    public boolean containsSource(int sourceLine) {
        return sourceLine >= this.getFirstSourceLine() && sourceLine <= this.getLastSourceLine();
    }

    public int getBestDecompiledLine(int sourceLine) {
        if (!this.containsSource(sourceLine)) {
            return -1;
        }
        Set<Integer> set = this.decompiledLines.keySet();
        if (set.size() == 0) {
            return -1;
        }
        int bestMatch = -1;
        for (Integer integer : set) {
            int line = integer;
            int delta = sourceLine - line;
            if (delta < 0) continue;
            if (delta == 0) {
                return line;
            }
            if (bestMatch >= 0 && delta >= sourceLine - bestMatch) continue;
            bestMatch = line;
        }
        if (bestMatch < 0) {
            return -1;
        }
        return this.decompiledLines.get(bestMatch);
    }

    private void analyzeMethod() {
        Object interpreter;
        try {
            Type type = Type.getType((String)this.owner);
            interpreter = new SimpleVerifier(589824, type, null, null, false){};
        }
        catch (Exception e) {
            interpreter = new BasicVerifier();
        }
        Analyzer a = new Analyzer((Interpreter)interpreter);
        try {
            a.analyze(this.owner, this.meth);
        }
        catch (AnalyzerException e) {
            this.error = e.getMessage();
            if (this.error.startsWith("Error at instruction ")) {
                this.error = this.error.substring("Error at instruction ".length());
                this.errorInsn = Integer.parseInt(this.error.substring(0, this.error.indexOf(58)));
                this.error = this.error.substring(this.error.indexOf(58) + 2);
            }
            BytecodeOutlinePlugin.log(e, 4);
            this.error = null;
        }
        this.frames = a.getFrames();
    }

    private void formatText(List<?> input, Map<Integer, String> locals, StringBuffer line, List<Object> result) {
        int i = 0;
        while (i < input.size()) {
            Object o = input.get(i);
            if (o instanceof List) {
                this.formatText((List)o, locals, line, result);
            } else if (o instanceof Index) {
                result.add(o);
                this.updateLocals((Index)o, locals);
            } else if (o instanceof Integer) {
                Index index;
                String localVariableName = locals.get(o);
                if (localVariableName == null && (index = DecompiledMethod.getNextIndex(input, i)) != null) {
                    this.updateLocals(index, locals);
                    localVariableName = locals.get(o);
                }
                if (localVariableName != null) {
                    line.append(": ").append(localVariableName);
                }
            } else {
                int p;
                String s = o.toString();
                do {
                    if ((p = s.indexOf(10)) == -1) {
                        line.append(s);
                        continue;
                    }
                    result.add(line.toString() + s.substring(0, p + 1));
                    s = s.substring(p + 1);
                    line.setLength(0);
                } while (p != -1);
            }
            ++i;
        }
    }

    private static Index getNextIndex(List<?> input, int startOffset) {
        int i = startOffset + 1;
        while (i < input.size()) {
            Object object = input.get(i);
            if (object instanceof Index) {
                return (Index)object;
            }
            ++i;
        }
        return null;
    }

    private void updateLocals(Index index, Map<Integer, String> locals) {
        for (LocalVariableNode lvNode : this.localVariables) {
            if (lvNode.start == index.labelNode) {
                locals.put(lvNode.index, lvNode.name);
                continue;
            }
            if (lvNode.end != index.labelNode) continue;
            locals.remove(lvNode.index);
        }
    }

    private void computeMaps(Map<Label, Integer> lineNumbers1) {
        int currentDecompiledLine = 0;
        int firstLine = -1;
        int lastLine = -1;
        for (Object o : this.text) {
            int currentOpcode = -1;
            int currentInsn1 = -1;
            int currentSourceLine = -1;
            if (o instanceof Index) {
                Index index = (Index)o;
                Integer sourceLine = null;
                if (index.labelNode != null) {
                    sourceLine = lineNumbers1.get(index.labelNode.getLabel());
                }
                if (sourceLine != null) {
                    currentSourceLine = sourceLine;
                    if (firstLine == -1 || currentSourceLine < firstLine) {
                        firstLine = currentSourceLine;
                    }
                    if (lastLine == -1 || currentSourceLine > lastLine) {
                        lastLine = currentSourceLine;
                    }
                }
                currentInsn1 = index.insn;
                currentOpcode = index.opcode;
            } else {
                ++currentDecompiledLine;
            }
            Integer cdl = currentDecompiledLine;
            Integer ci = currentInsn1;
            Integer co = currentOpcode;
            if (currentSourceLine >= 0) {
                Integer csl = currentSourceLine;
                this.sourceLines.put(cdl, csl);
                if (this.decompiledLines.get(csl) == null) {
                    this.decompiledLines.put(csl, cdl);
                }
            }
            this.insns.put(cdl, ci);
            this.opcodes.put(cdl, co);
            if (this.insnLines.get(ci) != null) continue;
            this.insnLines.put(ci, cdl);
        }
        this.lineCount = currentDecompiledLine;
        this.firstSourceLine = firstLine;
        this.lastSourceLine = lastLine;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        for (Object o : this.text) {
            if (o instanceof Index) continue;
            buf.append((String)o);
        }
        return buf.toString();
    }

    public String[][] getTextTable() {
        Frame<?> frame = null;
        String error1 = "";
        ArrayList<String[]> lines = new ArrayList<String[]>();
        Object offsStr = null;
        int i = 0;
        while (i < this.text.size()) {
            Object o = this.text.get(i);
            if (o instanceof Index) {
                Index index = (Index)o;
                int insn = index.insn;
                offsStr = "" + insn;
                if (this.frames != null && insn < this.frames.length) {
                    frame = this.frames[insn];
                    if (this.error != null && insn == this.errorInsn) {
                        error1 = this.error;
                    }
                }
            } else {
                if (offsStr == null) {
                    offsStr = "";
                }
                String locals = " ";
                String stack = " ";
                if (frame != null) {
                    StringBuffer buf = new StringBuffer();
                    DecompiledMethod.appendFrame(buf, frame);
                    int p = buf.indexOf(" ");
                    locals = buf.substring(0, p);
                    if ("".equals(locals)) {
                        locals = " ";
                    }
                    if ("".equals(stack = buf.substring(p + 1))) {
                        stack = " ";
                    }
                }
                lines.add(new String[]{offsStr, locals, stack, o.toString(), error1});
                frame = null;
                error1 = "";
                offsStr = null;
            }
            ++i;
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getErrorLine() {
        if (this.error == null) {
            return -1;
        }
        Integer i = this.insnLines.get(this.errorInsn);
        return i == null ? -1 : i;
    }

    private static void appendFrame(StringBuffer buf, Frame<?> f) {
        try {
            int i = 0;
            while (i < f.getLocals()) {
                DecompiledMethod.appendValue(buf, f.getLocal(i));
                ++i;
            }
            buf.append(' ');
            i = 0;
            while (i < f.getStackSize()) {
                DecompiledMethod.appendValue(buf, f.getStack(i));
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
    }

    private static void appendValue(StringBuffer buf, Value v) {
        if (((BasicValue)v).isReference()) {
            buf.append("R");
        } else {
            buf.append(v.toString());
        }
    }

    public int getFirstSourceLine() {
        return this.firstSourceLine;
    }

    public int getLastSourceLine() {
        return this.lastSourceLine;
    }

    public int getSourceLine(int decompiledLine) {
        Integer i = this.sourceLines.get(decompiledLine);
        return i == null ? -1 : i;
    }

    public Integer getBytecodeOffset(int decompiledLine) {
        return this.insns.get(decompiledLine);
    }

    public Integer getBytecodeInsn(int decompiledLine) {
        return this.opcodes.get(decompiledLine);
    }

    public String[][][] getFrameTables(int decompiledLine, boolean useQualifiedNames) {
        Integer insn = this.getBytecodeOffset(decompiledLine);
        if (insn == null) {
            return null;
        }
        return this.getFrameTablesForInsn(insn, useQualifiedNames);
    }

    public String[][][] getFrameTablesForInsn(int insn, boolean useQualifiedNames) {
        if (this.error != null && insn == this.errorInsn) {
            return null;
        }
        if (this.frames != null && insn >= 0 && insn < this.frames.length) {
            Frame<?> f = this.frames[insn];
            if (f == null) {
                return null;
            }
            try {
                ArrayList<String[]> locals = new ArrayList<String[]>();
                int i = 0;
                while (i < f.getLocals()) {
                    String varName = "";
                    for (LocalVariableNode lvnode : this.localVariables) {
                        int n = lvnode.index;
                        if (n != i) continue;
                        varName = lvnode.name;
                        break;
                    }
                    locals.add(new String[]{"" + i, DecompiledMethod.getTypeName(useQualifiedNames, f.getLocal(i).toString()), varName});
                    ++i;
                }
                ArrayList<String[]> stack = new ArrayList<String[]>();
                int i2 = 0;
                while (i2 < f.getStackSize()) {
                    stack.add(new String[]{"" + i2, DecompiledMethod.getTypeName(useQualifiedNames, f.getStack(i2).toString())});
                    ++i2;
                }
                return new String[][][]{(String[][])locals.toArray((T[])new String[3][]), (String[][])stack.toArray((T[])new String[2][])};
            }
            catch (IndexOutOfBoundsException e) {
                BytecodeOutlinePlugin.log(e, 4);
            }
        }
        return null;
    }

    private static String getTypeName(boolean useQualifiedNames, String s) {
        if (!useQualifiedNames) {
            Object arraySymbols = "";
            while (s.startsWith("[")) {
                arraySymbols = (String)arraySymbols + "[";
                s = s.substring(1);
            }
            int idx = s.lastIndexOf(47);
            if (idx > 0) {
                return (String)arraySymbols + s.substring(idx + 1, s.length() - 1);
            }
            if ("." == s) {
                return (String)arraySymbols + s;
            }
            if ("R" == s) {
                return (String)arraySymbols + s;
            }
            return (String)arraySymbols + CommentedClassVisitor.getSimpleName(Type.getType((String)s));
        }
        return "Lnull;".equals(s) ? "null" : s;
    }

    public int getDecompiledLine(int sourceLine) {
        Integer i = this.decompiledLines.get(sourceLine);
        return i == null ? -1 : i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecompiledMethod)) {
            return false;
        }
        DecompiledMethod another = (DecompiledMethod)o;
        return this.getSignature().equals(another.getSignature()) && (this.owner == null || this.owner.equals(another.owner));
    }

    public int hashCode() {
        return this.getSignature().hashCode() + (this.owner != null ? this.owner.hashCode() : 0);
    }
}

