/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;

public class DelegatingProgressMonitor
implements IDelegatingProgressMonitor {
    private boolean calledBeginTask;
    private boolean canceled;
    private Object data;
    private boolean done;
    private double internalWorked;
    private final List<IProgressMonitor> monitors = new CopyOnWriteArrayList<IProgressMonitor>();
    private String subTaskName;
    private String taskName;
    private int totalWork;
    private int worked;

    public static IDelegatingProgressMonitor getMonitorFrom(IProgressMonitor monitor) {
        if (monitor == null) {
            return null;
        }
        if (monitor instanceof IDelegatingProgressMonitor) {
            return (IDelegatingProgressMonitor)monitor;
        }
        if (monitor instanceof ProgressMonitorWrapper) {
            return DelegatingProgressMonitor.getMonitorFrom(((ProgressMonitorWrapper)monitor).getWrappedProgressMonitor());
        }
        return null;
    }

    @Override
    public void attach(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        if (this.calledBeginTask) {
            monitor.beginTask(this.taskName, this.totalWork);
        }
        if (this.taskName != null) {
            monitor.setTaskName(this.taskName);
        }
        if (this.subTaskName != null) {
            monitor.subTask(this.subTaskName);
        }
        if (this.worked > 0) {
            monitor.worked(this.worked);
        }
        if (this.internalWorked > 0.0) {
            monitor.internalWorked(this.internalWorked);
        }
        if (this.canceled) {
            monitor.setCanceled(this.canceled);
        }
        if (this.done) {
            monitor.done();
        }
        this.monitors.add(monitor);
    }

    public void beginTask(String name, int totalWork) {
        if (!this.calledBeginTask) {
            this.taskName = name;
            this.totalWork = totalWork;
            this.calledBeginTask = true;
        }
        for (IProgressMonitor monitor : this.monitors) {
            monitor.beginTask(name, totalWork);
        }
    }

    @Override
    public void detach(IProgressMonitor monitor) {
        this.monitors.remove(monitor);
    }

    public void done() {
        this.done = true;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.done();
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public void internalWorked(double work) {
        this.internalWorked += work;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        boolean canceled = false;
        for (IProgressMonitor monitor : this.monitors) {
            canceled |= monitor.isCanceled();
        }
        if (canceled) {
            this.setCanceled(canceled);
        }
        return canceled;
    }

    public void setCanceled(boolean value) {
        this.canceled = value;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setCanceled(value);
        }
    }

    @Override
    public void setData(Object o) {
        this.data = o;
    }

    public void setTaskName(String name) {
        this.taskName = name;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        this.subTaskName = name;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.subTask(name);
        }
    }

    public void worked(int work) {
        this.worked += work;
        for (IProgressMonitor monitor : this.monitors) {
            monitor.worked(work);
        }
    }
}

