/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ReferencedGrammarInfo;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.extensions.xerces.AbstractReferencedGrammarLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.xinclude.XIncludeErrorCode;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class LSPErrorReporterForXML
extends AbstractReferencedGrammarLSPErrorReporter {
    private static final String XML_DIAGNOSTIC_SOURCE = "xml";
    private Set<ReferencedGrammarInfo> referencedGrammars;

    public LSPErrorReporterForXML(DOMDocument xmlDocument, List<Diagnostic> diagnostics, ContentModelManager contentModelManager, boolean hasRelatedInformation, Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache) {
        super(XML_DIAGNOSTIC_SOURCE, xmlDocument, diagnostics, contentModelManager, hasRelatedInformation, referencedGrammarDiagnosticsInfoCache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Range toLSPRange(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, DOMDocument document, String documentOrGrammarURI, boolean errorForDocument) {
        XIncludeErrorCode xIncludeCode;
        XMLSyntaxErrorCode syntaxCode = XMLSyntaxErrorCode.get(key);
        if (syntaxCode != null) {
            if (errorForDocument) {
                Range range = XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, document);
                if (range == null) return null;
                return range;
            }
            this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), syntaxCode, null, null, null, null, null, documentOrGrammarURI);
            return NO_RANGE;
        }
        XMLSchemaErrorCode schemaCode = XMLSchemaErrorCode.get(key);
        if (schemaCode != null) {
            Range range = XMLSchemaErrorCode.toLSPRange(location, schemaCode, arguments, document);
            if (range == null) return null;
            return range;
        }
        DTDErrorCode dtdCode = DTDErrorCode.get(key);
        if (dtdCode != null) {
            if (errorForDocument) {
                Range range = DTDErrorCode.toLSPRange(location, dtdCode, arguments, document);
                if (range == null) return null;
                return range;
            }
            this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, dtdCode, null, null, null, documentOrGrammarURI);
            return NO_RANGE;
        }
        XSDErrorCode xsdCode = XSDErrorCode.get(key);
        if (xsdCode != null && !errorForDocument) {
            this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, null, xsdCode, null, null, documentOrGrammarURI);
            return NO_RANGE;
        }
        RelaxNGErrorCode rngCode = RelaxNGErrorCode.get(key);
        if (rngCode != null) {
            if (errorForDocument) {
                Range range = RelaxNGErrorCode.toLSPRange(location, rngCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, null, null, rngCode, null, documentOrGrammarURI);
                return NO_RANGE;
            }
        }
        if ((xIncludeCode = XIncludeErrorCode.get(key)) == null) return null;
        if (errorForDocument) {
            Range range = XIncludeErrorCode.toLSPRange(location, xIncludeCode, arguments, document);
            if (range == null) return null;
            return range;
        }
        this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, null, null, null, xIncludeCode, documentOrGrammarURI);
        return NO_RANGE;
    }

    @Override
    protected boolean isIgnoreFatalError(String key) {
        return DTDErrorCode.EntityNotDeclared.name().equals(key);
    }

    @Override
    protected Range getReferencedGrammarRange(String grammarURI) {
        Set<ReferencedGrammarInfo> referencedGrammars = this.getReferencedGrammars();
        for (ReferencedGrammarInfo referencedGrammarInfo : referencedGrammars) {
            DOMRange range;
            if (!grammarURI.equals(referencedGrammarInfo.getResolvedURIInfo().getResolvedURI()) || (range = referencedGrammarInfo.getIdentifier() != null ? referencedGrammarInfo.getIdentifier().getRange() : null) == null) continue;
            return XMLPositionUtility.createRange(range);
        }
        return XMLPositionUtility.selectRootStartTag(this.getDOMDocument());
    }

    private Set<ReferencedGrammarInfo> getReferencedGrammars() {
        if (this.referencedGrammars != null) {
            return this.referencedGrammars;
        }
        this.referencedGrammars = this.contentModelManager.getReferencedGrammarInfos(super.getDOMDocument());
        return this.referencedGrammars;
    }
}

