/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.forms;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.forms.InPlaceDateSelectionDialog;
import org.eclipse.mylyn.internal.commons.workbench.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DatePicker
extends Composite {
    public static final String TITLE_DIALOG = Messages.DatePicker_Choose_Date;
    public static final String LABEL_CHOOSE = Messages.DatePicker_Choose_Date;
    private Text dateText;
    private Button pickButton;
    private Calendar date;
    private final List<SelectionListener> pickerListeners = new LinkedList<SelectionListener>();
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
    private String initialText = LABEL_CHOOSE;
    private final boolean includeTimeOfday;
    private final int hourOfDay = 0;
    private int selectedHourOfDay = 0;
    private ImageHyperlink clearControl;

    public DatePicker(Composite parent, int style, String initialText, boolean includeHours, int selectedHourOfDay) {
        super(parent, style);
        this.initialText = initialText;
        this.includeTimeOfday = includeHours;
        this.selectedHourOfDay = selectedHourOfDay;
        this.initialize((style & 0x800000) != 0 ? 0x800000 : 0);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDatePattern(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    private void initialize(int style) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.dateText = new Text((Composite)this, style);
        GridData dateTextGridData = new GridData(4, 4, false, false);
        dateTextGridData.heightHint = 5;
        dateTextGridData.grabExcessHorizontalSpace = true;
        dateTextGridData.verticalAlignment = 4;
        this.dateText.setLayoutData((Object)dateTextGridData);
        this.dateText.setText(this.initialText);
        this.dateText.addFocusListener((FocusListener)new FocusAdapter(){
            Calendar calendar = Calendar.getInstance();

            public void focusLost(FocusEvent e) {
                try {
                    Date reminderDate = DatePicker.this.dateFormat.parse(DatePicker.this.dateText.getText());
                    this.calendar.setTime(reminderDate);
                    DatePicker.this.date = this.calendar;
                    DatePicker.this.updateDateText();
                    DatePicker.this.notifyPickerListeners();
                }
                catch (ParseException e1) {
                    DatePicker.this.updateDateText();
                }
            }
        });
        this.clearControl = new ImageHyperlink((Composite)this, 0);
        this.clearControl.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR_DISABLED));
        this.clearControl.setHoverImage(CommonImages.getImage((ImageDescriptor)CommonImages.FIND_CLEAR));
        this.clearControl.setToolTipText(Messages.DatePicker_Clear);
        this.clearControl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DatePicker.this.dateSelected(false, null);
            }
        });
        this.clearControl.setBackground(this.clearControl.getDisplay().getSystemColor(1));
        GridData clearButtonGridData = new GridData();
        clearButtonGridData.horizontalIndent = 3;
        this.clearControl.setLayoutData((Object)clearButtonGridData);
        this.pickButton = new Button((Composite)this, style | 4 | 0x400);
        GridData pickButtonGridData = new GridData(131072, 4, false, true);
        pickButtonGridData.verticalIndent = 0;
        pickButtonGridData.horizontalIndent = 3;
        this.pickButton.setLayoutData((Object)pickButtonGridData);
        this.pickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Shell shell;
                Calendar newCalendar = Calendar.getInstance();
                newCalendar.set(11, 0);
                newCalendar.set(12, 0);
                newCalendar.set(13, 0);
                newCalendar.set(14, 0);
                if (DatePicker.this.date != null) {
                    newCalendar.setTime(DatePicker.this.date.getTime());
                }
                if ((shell = DatePicker.this.pickButton.getShell()) == null) {
                    shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(PlatformUI.getWorkbench().getDisplay());
                }
                InPlaceDateSelectionDialog dialog = new InPlaceDateSelectionDialog(shell, (Control)DatePicker.this.pickButton, newCalendar, TITLE_DIALOG, DatePicker.this.includeTimeOfday, DatePicker.this.selectedHourOfDay);
                dialog.addEventListener(event -> {
                    Calendar selectedCalendar = null;
                    if (event.getReturnCode() == 0 && dialog.getDate() != null) {
                        selectedCalendar = newCalendar;
                        selectedCalendar.setTime(dialog.getDate());
                    }
                    DatePicker.this.dateSelected(event.getReturnCode() == 1, selectedCalendar);
                });
                dialog.open();
            }
        });
        this.updateClearControlVisibility();
        this.pack();
        this.setBackground(this.getDisplay().getSystemColor(25));
    }

    public void addPickerSelectionListener(SelectionListener listener) {
        this.pickerListeners.add(listener);
    }

    public Calendar getDate() {
        return this.date;
    }

    public void setBackground(Color backgroundColor) {
        super.setBackground(backgroundColor);
        this.dateText.setBackground(backgroundColor);
        if ((this.getStyle() & 0x800000) != 0) {
            this.pickButton.setBackground(backgroundColor);
            this.clearControl.setBackground(backgroundColor);
        } else {
            this.pickButton.setBackground(null);
            this.clearControl.setBackground(null);
        }
    }

    public void setDate(Calendar date) {
        this.date = date;
        this.updateDateText();
    }

    protected void dateSelected(boolean canceled, Calendar selectedDate) {
        if (!canceled) {
            this.date = selectedDate != null ? selectedDate : null;
            this.updateDateText();
            this.notifyPickerListeners();
        }
    }

    private void notifyPickerListeners() {
        for (SelectionListener listener : this.pickerListeners) {
            listener.widgetSelected(null);
        }
    }

    private void updateDateText() {
        if (this.date != null) {
            Date currentDate = new Date(this.date.getTimeInMillis());
            this.dateText.setText(this.dateFormat.format(currentDate));
        } else {
            this.dateText.setEnabled(false);
            this.dateText.setText(LABEL_CHOOSE);
            this.dateText.setEnabled(true);
        }
        this.updateClearControlVisibility();
    }

    private void updateClearControlVisibility() {
        if (this.clearControl != null && this.clearControl.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)this.clearControl.getLayoutData();
            gd.exclude = this.date == null;
            this.clearControl.getParent().layout();
        }
    }

    public void setEnabled(boolean enabled) {
        this.dateText.setEnabled(enabled);
        this.pickButton.setEnabled(enabled);
        this.clearControl.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

