/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;

public class Logger {
    public static final boolean DEBUG_DEFINITION_PERSISTENCE = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.common.snippets/debug/definition_persistence"));
    public static final boolean DEBUG_DRAG_AND_DROP = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.common.snippets/debug/drag_and_drop"));
    public static final boolean DEBUG_PALETTE_SELECTION = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.common.snippets/debug/palette_selection"));
    public static final boolean DEBUG_VIEWER_CONTENT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.common.snippets/debug/viewer_content"));
    public static final int ERROR = 4;
    public static final int ERROR_DEBUG = 204;
    private static Plugin fPlugin = SnippetsPlugin.getDefault();
    private static final String fPluginId = fPlugin.getBundle().getSymbolicName();
    public static final int INFO = 1;
    public static final int INFO_DEBUG = 201;
    public static final int OK = 0;
    public static final int OK_DEBUG = 200;
    private static final String TRACEFILTER_LOCATION = "/debug/tracefilter";
    public static final int WARNING = 2;
    public static final int WARNING_DEBUG = 202;

    protected static void _log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || Logger.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        String text = message != null ? message : "null";
        Status statusObj = new Status(severity, fPluginId, severity, text, exception);
        fPlugin.getLog().log((IStatus)statusObj);
    }

    protected static void _trace(String category, String message, Throwable exception) {
        if (Logger.isTracing(category)) {
            String text = message != null ? message : "null";
            Status statusObj = new Status(0, fPluginId, 0, text, exception);
            fPlugin.getLog().log((IStatus)statusObj);
        }
    }

    public static boolean isDebugging() {
        return fPlugin.isDebugging();
    }

    public static boolean isTracing(String category) {
        if (!Logger.isDebugging()) {
            return false;
        }
        String traceFilter = Platform.getDebugOption((String)(fPluginId + TRACEFILTER_LOCATION));
        if (traceFilter != null) {
            StringTokenizer tokenizer = new StringTokenizer(traceFilter, ",");
            while (tokenizer.hasMoreTokens()) {
                String cat = tokenizer.nextToken().trim();
                if (!category.equals(cat)) continue;
                return true;
            }
        }
        return false;
    }

    public static void log(int level, String message) {
        Logger._log(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        Logger._log(level, message, exception);
    }

    public static void logException(String message, Throwable exception) {
        Logger._log(4, message, exception);
    }

    public static void logException(Throwable exception) {
        Logger._log(4, exception.getMessage(), exception);
    }

    public static void trace(String category, String message) {
        Logger._trace(category, message, null);
    }

    public static void traceException(String category, String message, Throwable exception) {
        Logger._trace(category, message, exception);
    }

    public static void traceException(String category, Throwable exception) {
        Logger._trace(category, exception.getMessage(), exception);
    }
}

