/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.DataTypeImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.AbstractNodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.ObjectLiteralSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class ObjectLiteralDataTypeSpi
extends AbstractNodeElementSpi<IDataType>
implements DataTypeSpi {
    private final String m_name;
    private final ObjectLiteralSpi m_objectLiteral;

    protected ObjectLiteralDataTypeSpi(NodeModuleSpi module, String name, ObjectLiteralSpi objectLiteral) {
        super(module);
        this.m_name = (String)Ensure.notNull((Object)name);
        this.m_objectLiteral = (ObjectLiteralSpi)Ensure.notNull((Object)objectLiteral);
    }

    @Override
    public INodeElement.ExportType exportType() {
        return INodeElement.ExportType.NONE;
    }

    @Override
    protected Path resolveContainingFile() {
        return this.m_objectLiteral.containingFile().orElse(null);
    }

    @Override
    protected IDataType createApi() {
        return new DataTypeImplementor<ObjectLiteralDataTypeSpi>(this);
    }

    @Override
    public String name() {
        return this.m_name;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Collection<DataTypeSpi> childTypes() {
        return Collections.emptyList();
    }

    @Override
    public Optional<ObjectLiteralSpi> objectLiteral() {
        return Optional.of(this.m_objectLiteral);
    }

    @Override
    public Optional<SourceRange> source() {
        return this.m_objectLiteral.source();
    }
}

