/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.query;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.typescript.model.spi.ES6ClassSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class FieldQuery
extends AbstractQuery<IField> {
    private final ES6ClassSpi m_es6ClassSpi;
    private String m_name;
    private Modifier m_requiredModifier;
    private Modifier m_notAllowedModifier;

    public FieldQuery(ES6ClassSpi es6Class) {
        this.m_es6ClassSpi = (ES6ClassSpi)Ensure.notNull((Object)es6Class);
    }

    public FieldQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String getName() {
        return this.m_name;
    }

    public FieldQuery withoutModifier(Modifier modifier) {
        this.m_notAllowedModifier = modifier;
        return this;
    }

    protected Modifier getNotAllowedModifier() {
        return this.m_notAllowedModifier;
    }

    public FieldQuery withModifier(Modifier modifier) {
        this.m_requiredModifier = modifier;
        return this;
    }

    protected Modifier getRequiredModifier() {
        return this.m_requiredModifier;
    }

    protected ES6ClassSpi es6Class() {
        return this.m_es6ClassSpi;
    }

    protected Stream<IField> createStream() {
        return this.es6Class().fields().stream().filter(this::test).map(FieldSpi::api);
    }

    protected boolean test(FieldSpi field) {
        String name = this.getName();
        if (name != null && !name.equals(field.name())) {
            return false;
        }
        Modifier requiredModifier = this.getRequiredModifier();
        if (requiredModifier != null && !field.hasModifier(requiredModifier)) {
            return false;
        }
        Modifier notAllowedModifier = this.getNotAllowedModifier();
        return notAllowedModifier == null || !field.hasModifier(notAllowedModifier);
    }
}

