/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.util.Arrays;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;

public final class JsonPointer {
    private final String[] m_tokens;
    private final CharSequence m_raw;

    private JsonPointer(String[] tokens, CharSequence pointer) {
        this.m_tokens = tokens;
        this.m_raw = pointer;
    }

    public static JsonPointer compile(CharSequence pointer) {
        if (Strings.isEmpty((CharSequence)pointer)) {
            return new JsonPointer(null, pointer);
        }
        String[] tokens = (String[])CoreUtils.PATH_SEGMENT_SPLIT_PATTERN.splitAsStream(pointer).map(JsonPointer::decode).toArray(String[]::new);
        if (!Strings.isEmpty((CharSequence)tokens[0])) {
            throw new SdkException((CharSequence)"A non-empty JSON Pointer must begin with a slash ('/').", new Object[0]);
        }
        return new JsonPointer(tokens, pointer);
    }

    public IJsonPointerElement find(IJsonPointerElement start) {
        IJsonPointerElement result = start;
        if (this.m_tokens == null || this.m_tokens.length < 2) {
            return result;
        }
        int numSegments = this.m_tokens.length;
        for (int i = 1; i < numSegments; ++i) {
            if (result.isObject()) {
                if ((result = result.element(this.m_tokens[i])) != null) continue;
                return null;
            }
            int arrayLen = result.arrayLength();
            if (arrayLen > 0) {
                int index = JsonPointer.getIndex(this.m_tokens[i]);
                if (index > arrayLen) {
                    return null;
                }
                result = result.element(index);
                continue;
            }
            return null;
        }
        return result;
    }

    static int getIndex(String token) {
        if (Strings.isBlank((CharSequence)token)) {
            throw new SdkException((CharSequence)"Array index format error, was '{}'.", new Object[]{token});
        }
        if ("0".equals(token)) {
            return 0;
        }
        if (token.charAt(0) == '+' || token.charAt(0) == '-') {
            throw new SdkException((CharSequence)"Array index format error, was '{}'.", new Object[]{token});
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException ex) {
            throw new SdkException((CharSequence)"Illegal integer format, was '{}'.", new Object[]{token});
        }
    }

    static String decode(CharSequence escapedToken) {
        StringBuilder unescapedToken = new StringBuilder(escapedToken.length());
        for (int j = 0; j < escapedToken.length(); ++j) {
            int ch = escapedToken.charAt(j);
            if (ch == 126 && j < escapedToken.length() - 1) {
                char ch1 = escapedToken.charAt(j + 1);
                if (ch1 == '0') {
                    ++j;
                } else if (ch1 == '1') {
                    ch = 47;
                    ++j;
                }
            }
            unescapedToken.append((char)ch);
        }
        return unescapedToken.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.m_tokens, ((JsonPointer)o).m_tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_tokens);
    }

    public String toString() {
        if (this.m_raw == null) {
            return "null";
        }
        return this.m_raw.toString();
    }

    public static interface IJsonPointerElement {
        public int arrayLength();

        public boolean isObject();

        public IJsonPointerElement element(String var1);

        public IJsonPointerElement element(int var1);
    }
}

