/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EJBJarFileImpl
extends ModuleFileImpl
implements EJBJarFile {
    protected EJBJar deploymentDescriptor = null;

    @Override
    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.EJB_JAR_FILE;
    }

    @Override
    public List getAssociatedFiles(EnterpriseBean ejb) {
        String className;
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<File> result = new ArrayList<File>();
        if (ejb.getVersionID() <= 11) {
            classNames.add(ejb.getHomeInterfaceName());
            classNames.add(ejb.getRemoteInterfaceName());
        } else if (ejb.getVersionID() >= 20) {
            if (ejb.hasRemoteClient()) {
                classNames.add(ejb.getHomeInterfaceName());
                classNames.add(ejb.getRemoteInterfaceName());
            }
            if (ejb.hasLocalClient()) {
                classNames.add(ejb.getLocalHomeInterfaceName());
                classNames.add(ejb.getLocalInterfaceName());
            }
        }
        classNames.add(ejb.getEjbClassName());
        if (ejb.isEntity() && !(className = ((Entity)ejb).getPrimaryKeyName()).startsWith("java")) {
            classNames.add(className);
        }
        int i = 0;
        while (i < classNames.size()) {
            String className2 = (String)classNames.get(i);
            if (className2 != null) {
                String classUri = ArchiveUtil.classNameToUri(className2);
                String javaUri = ArchiveUtil.classNameToJavaUri(className2);
                try {
                    result.add(this.getFile(classUri));
                }
                catch (FileNotFoundException fileNotFoundException) {}
                try {
                    result.add(this.getFile(javaUri));
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            ++i;
        }
        return result;
    }

    @Override
    public EJBJar getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        EJBJar dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (DeploymentDescriptorLoadException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.getDeploymentDescriptorGen();
    }

    @Override
    public String getDeploymentDescriptorUri() {
        return "META-INF/ejb-jar.xml";
    }

    @Override
    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    @Override
    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    @Override
    public boolean isEJBJarFile() {
        return true;
    }

    @Override
    public boolean isImportedFrom10() {
        return this.getImportStrategy() != null && this.getImportStrategy().isEJB10();
    }

    @Override
    public EObject makeDeploymentDescriptor(XMLResource resource) {
        EJBJar ejbJar = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createEJBJar();
        resource.setID(ejbJar, "ejb-jar_ID");
        this.setDeploymentDescriptorGen(ejbJar);
        resource.getContents().add((Object)ejbJar);
        return ejbJar;
    }

    @Override
    public void setDeploymentDescriptor(EJBJar l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), l);
    }

    public EJBJar getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (EJBJar)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public EJBJar basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(EJBJar newDeploymentDescriptor) {
        EJBJar oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((EJBJar)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

