/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.internal.MethodImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationMethodWithEcj
extends AbstractMemberWithEcj<IMethod>
implements MethodSpi {
    private final DeclarationTypeWithEcj m_declaringType;
    private final AbstractMethodDeclaration m_astNode;
    private final FinalValue<TypeSpi> m_returnType;
    private final FinalValue<List<DeclarationAnnotationWithEcj>> m_annotations;
    private final FinalValue<List<MethodParameterSpi>> m_arguments;
    private final FinalValue<String> m_name;
    private final FinalValue<List<TypeSpi>> m_exceptions;
    private final FinalValue<List<TypeParameterSpi>> m_typeParameters;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_bodySource;
    private final FinalValue<SourceRange> m_javaDocSource;
    private final FinalValue<String> m_methodId;
    private int m_flags;

    protected DeclarationMethodWithEcj(AbstractJavaEnvironment env, DeclarationTypeWithEcj declaringType, AbstractMethodDeclaration astNode) {
        super(env);
        this.m_declaringType = (DeclarationTypeWithEcj)((Object)Ensure.notNull((Object)((Object)declaringType)));
        this.m_astNode = (AbstractMethodDeclaration)Ensure.notNull((Object)astNode);
        this.m_flags = -1;
        this.m_returnType = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_arguments = new FinalValue();
        this.m_name = new FinalValue();
        this.m_exceptions = new FinalValue();
        this.m_typeParameters = new FinalValue();
        this.m_source = new FinalValue();
        this.m_bodySource = new FinalValue();
        this.m_javaDocSource = new FinalValue();
        this.m_methodId = new FinalValue();
    }

    public MethodSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewMethodIn(this.getDeclaringType(), this.getMethodId());
    }

    public String getMethodId() {
        return (String)this.m_methodId.computeIfAbsentAndGet(() -> JavaTypes.createMethodIdentifier((MethodSpi)this));
    }

    protected IMethod internalCreateApi() {
        return new MethodImplementor((MethodSpi)this);
    }

    public AbstractMethodDeclaration getInternalMethodDeclaration() {
        return this.m_astNode;
    }

    public boolean isConstructor() {
        return this.m_astNode.isConstructor();
    }

    public TypeSpi getReturnType() {
        return (TypeSpi)this.m_returnType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), this.resolveReturnType(this), () -> (TypeBinding)this.withNewElement(this::resolveReturnType)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeBinding resolveReturnType(DeclarationMethodWithEcj declaration) {
        AbstractMethodDeclaration abstractMethodDeclaration = declaration.m_astNode;
        if (!(abstractMethodDeclaration instanceof MethodDeclaration)) {
            return null;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
        TypeReference ref = methodDeclaration.returnType;
        if (ref.resolvedType != null) {
            return ref.resolvedType;
        }
        Object object = this.javaEnvWithEcj().lock();
        synchronized (object) {
            return ref.resolveType((BlockScope)methodDeclaration.scope);
        }
    }

    public List<DeclarationAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createDeclarationAnnotations(this.javaEnvWithEcj(), (AnnotatableSpi)this, this.m_astNode.annotations));
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getMethodFlags(this.m_astNode.modifiers, this.isVarArgs(), SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    private boolean isVarArgs() {
        Argument[] arguments = this.m_astNode.arguments;
        return arguments != null && arguments.length > 0 && arguments[arguments.length - 1].isVarArgs();
    }

    public List<MethodParameterSpi> getParameters() {
        return (List)this.m_arguments.computeIfAbsentAndGet(() -> {
            Argument[] arguments = this.m_astNode.arguments;
            if (arguments == null || arguments.length < 1) {
                return Collections.emptyList();
            }
            return IntStream.range(0, arguments.length).mapToObj(i -> this.javaEnvWithEcj().createDeclarationMethodParameter(this, arguments[i], i)).collect(Collectors.toList());
        });
    }

    public DeclarationTypeWithEcj getDeclaringType() {
        return this.m_declaringType;
    }

    public String getElementName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> {
            if (this.m_astNode.selector != null) {
                return new String(this.m_astNode.selector);
            }
            if (this.m_astNode.binding.selector != null) {
                return new String(this.m_astNode.binding.selector);
            }
            return "<clinit>";
        });
    }

    public List<TypeSpi> getExceptionTypes() {
        return (List)this.m_exceptions.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), this.resolveExceptionTypes(this), () -> (TypeBinding[])this.withNewElement(this::resolveExceptionTypes)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeBinding[] resolveExceptionTypes(DeclarationMethodWithEcj method) {
        TypeReference[] exceptions = method.m_astNode.thrownExceptions;
        if (exceptions == null || exceptions.length < 1) {
            return Binding.NO_TYPES;
        }
        ArrayList<TypeBinding> result = new ArrayList<TypeBinding>(exceptions.length);
        for (TypeReference r : exceptions) {
            TypeBinding resolved = r.resolvedType;
            if (resolved == null) {
                Object object = this.javaEnvWithEcj().lock();
                synchronized (object) {
                    resolved = r.resolveType((BlockScope)method.m_astNode.scope);
                }
            }
            if (resolved == null) continue;
            result.add(resolved);
        }
        return result.toArray(new TypeBinding[0]);
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return (List)this.m_typeParameters.computeIfAbsentAndGet(() -> SpiWithEcjUtils.toTypeParameterSpi(this.m_astNode.typeParameters(), this, this.javaEnvWithEcj()));
    }

    public boolean hasTypeParameters() {
        TypeParameter[] typeParams = this.m_astNode.typeParameters();
        return typeParams != null && typeParams.length > 0;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), this.m_astNode.declarationSourceStart, this.m_astNode.declarationSourceEnd));
    }

    public SourceRange getSourceOfBody() {
        return (SourceRange)this.m_bodySource.computeIfAbsentAndGet(() -> this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), this.m_astNode.bodyStart, this.m_astNode.bodyEnd));
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createSourceRange((ASTNode)this.m_astNode.javadoc, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj()));
    }

    public SourceRange getSourceOfDeclaration() {
        return SpiWithEcjUtils.createSourceRange((ASTNode)this.m_astNode, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj());
    }
}

