/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.scout.sdk.core.s.widgetmap.ColumnMap;
import org.eclipse.scout.sdk.core.s.widgetmap.Type;
import org.eclipse.scout.sdk.core.s.widgetmap.WidgetMap;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ObjectType
extends Type {
    private final IES6Class m_es6Class;
    private WidgetMap m_widgetMap = null;
    private ColumnMap m_columnMap = null;

    protected ObjectType(IES6Class es6Class, Collection<String> usedNames) {
        super((Collection)Ensure.notNull(usedNames));
        this.m_es6Class = (IES6Class)Ensure.notNull((Object)es6Class);
    }

    public static Optional<ObjectType> create(IES6Class es6Class, Collection<String> usedNames) {
        if (es6Class == null || usedNames == null) {
            return Optional.empty();
        }
        return Optional.of(new ObjectType(es6Class, usedNames));
    }

    public IES6Class es6Class() {
        return this.m_es6Class;
    }

    public boolean isInstanceOf(IES6Class es6Class) {
        return this.es6Class().isInstanceOf(es6Class);
    }

    @Override
    public ObjectType withNewClassName(CharSequence newClassName) {
        super.withNewClassName(newClassName);
        return this;
    }

    public Optional<WidgetMap> widgetMap() {
        return Optional.ofNullable(this.m_widgetMap).filter(wm -> !wm.elements().isEmpty());
    }

    public ObjectType withWidgetMap(WidgetMap widgetMap) {
        this.m_widgetMap = widgetMap;
        return this;
    }

    public Optional<ColumnMap> columnMap() {
        return Optional.ofNullable(this.m_columnMap).filter(cm -> !cm.elements().isEmpty());
    }

    public ObjectType withColumnMap(ColumnMap columnMap) {
        this.m_columnMap = columnMap;
        return this;
    }

    public ObjectType withNewClassNameAndMaps(CharSequence newClassName, IObjectLiteral model) {
        this.withNewClassName(newClassName);
        WidgetMap.create(this.newClassName().orElse(null), model, null, this.usedNames()).ifPresent(this::withWidgetMap);
        ColumnMap.create(this.newClassName().orElse(null), model, this.usedNames()).ifPresent(this::withColumnMap);
        return this;
    }
}

