/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.enums;

import java.util.List;
import java.util.Optional;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeFulfillsEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class ES6ClassEnumScoutEnum
implements IScoutJsEnum {
    private final ScoutJsModel m_scoutJsModel;
    private final IES6Class m_class;
    private final FinalValue<List<String>> m_constants;

    protected ES6ClassEnumScoutEnum(ScoutJsModel scoutJsModel, IES6Class clazz) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_class = clazz;
        this.m_constants = new FinalValue();
    }

    public static Optional<IScoutJsEnum> create(ScoutJsModel owner, IES6Class clazz) {
        if (owner == null || clazz == null || !clazz.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(new ES6ClassEnumScoutEnum(owner, clazz));
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    @Override
    public String name() {
        return this.declaringClass().name();
    }

    @Override
    public IES6Class declaringClass() {
        return this.m_class;
    }

    @Override
    public INodeElement topLevelReference() {
        return this.declaringClass();
    }

    @Override
    public List<String> constants() {
        return (List)this.m_constants.computeIfAbsentAndGet(this::parseConstants);
    }

    protected List<String> parseConstants() {
        return this.declaringClass().fields().stream().map(INodeElement::name).toList();
    }

    @Override
    public boolean fulfills(IDataType dataType) {
        return new DataTypeFulfillsEvaluator(dt -> dt == this.declaringClass()).fulfills(dataType);
    }

    public String toString() {
        return this.declaringClass().toString();
    }
}

