/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.s.model.js.IScoutJsElement;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsElementSpliterator;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;

public abstract class AbstractScoutJsElementQuery<E extends IScoutJsElement, TYPE extends AbstractScoutJsElementQuery<E, TYPE>>
extends AbstractQuery<E> {
    private final ScoutJsModel m_model;
    private boolean m_includeDependencies;
    private boolean m_includeSelf = true;
    private String m_name;
    private Set<IES6Class> m_declaringClasses;

    protected AbstractScoutJsElementQuery(ScoutJsModel model) {
        this.m_model = model;
    }

    protected ScoutJsModel model() {
        return this.m_model;
    }

    protected TYPE thisInstance() {
        return (TYPE)((Object)this);
    }

    public TYPE withIncludeDependencies(boolean includeDependencies) {
        this.m_includeDependencies = includeDependencies;
        return this.thisInstance();
    }

    protected boolean isIncludeDependencies() {
        return this.m_includeDependencies;
    }

    public TYPE withIncludeSelf(boolean includeSelf) {
        this.m_includeSelf = includeSelf;
        return this.thisInstance();
    }

    protected boolean isIncludeSelf() {
        return this.m_includeSelf;
    }

    public TYPE withName(String name) {
        this.m_name = name;
        return this.thisInstance();
    }

    protected String name() {
        return this.m_name;
    }

    public TYPE withDeclaringClasses(Stream<? extends IES6Class> declaringClasses) {
        this.m_declaringClasses = declaringClasses == null ? null : declaringClasses.map(IES6Class::withoutTypeArguments).collect(Collectors.toUnmodifiableSet());
        return this.thisInstance();
    }

    public TYPE withDeclaringClasses(Collection<? extends IES6Class> declaringClasses) {
        if (declaringClasses == null) {
            this.m_declaringClasses = null;
            return this.thisInstance();
        }
        return this.withDeclaringClasses(declaringClasses.stream());
    }

    public TYPE withDeclaringClass(IES6Class declaringClass) {
        if (declaringClass == null) {
            this.m_declaringClasses = null;
            return this.thisInstance();
        }
        return this.withDeclaringClasses(Stream.of(declaringClass));
    }

    protected Set<IES6Class> declaringClasses() {
        return this.m_declaringClasses;
    }

    protected Stream<E> createStream() {
        Predicate<E> filter = this.createFilter();
        Stream<E> stream = StreamSupport.stream(this.createSpliterator(), false);
        if (filter == null) {
            return stream;
        }
        return stream.filter(filter);
    }

    protected abstract ScoutJsElementSpliterator<E> createSpliterator();

    protected Predicate<E> createFilter() {
        Set<IES6Class> declaringClassFilter;
        Predicate<IScoutJsElement> result = null;
        String name = this.name();
        if (name != null) {
            result = AbstractScoutJsElementQuery.appendOrCreateFilter(null, e -> this.name().equals(e.name()));
        }
        if ((declaringClassFilter = this.declaringClasses()) != null) {
            result = AbstractScoutJsElementQuery.appendOrCreateFilter(result, e -> declaringClassFilter.contains(e.declaringClass()));
        }
        return result;
    }

    protected static <E extends IScoutJsElement> Predicate<E> appendOrCreateFilter(Predicate<E> existing, Predicate<E> toAppend) {
        if (existing == null) {
            return toAppend;
        }
        return existing.and(toAppend);
    }
}

