/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.java.apidef;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ScoutModelHierarchy {
    private final IScoutApi m_api;
    private final Map<String, Set<String>> m_childrenByContainer = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> m_interfaceHierarchy = new HashMap<String, Set<String>>();

    protected ScoutModelHierarchy(IScoutApi api) {
        this.m_api = (IScoutApi)Ensure.notNull((Object)api);
        this.addContainerElement(api.AbstractAccordion().fqn(), api.IGroup().fqn());
        this.addContainerElement(api.AbstractAccordionField().fqn(), api.IAccordion().fqn());
        this.addContainerElement(api.AbstractAccordionFieldExtension().fqn(), api.IAccordion().fqn());
        this.addContainerElement(api.AbstractActionExtension().fqn(), api.IAction().fqn());
        this.addContainerElement(api.AbstractActionNode().fqn(), api.IActionNode().fqn());
        this.addContainerElement(api.AbstractActionNodeExtension().fqn(), api.IActionNode().fqn());
        this.addContainerElement(api.AbstractButton().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractButtonExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractCalendar().fqn(), api.ICalendarItemProvider().fqn());
        this.addContainerElement(api.AbstractCalendar().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractCalendarExtension().fqn(), api.ICalendarItemProvider().fqn());
        this.addContainerElement(api.AbstractCalendarExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractCalendarField().fqn(), api.ICalendar().fqn());
        this.addContainerElement(api.AbstractCalendarFieldExtension().fqn(), api.ICalendar().fqn());
        this.addContainerElement(api.AbstractCalendarItemProvider().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractCalendarItemProviderExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractCode().fqn(), api.ICode().fqn());
        this.addContainerElement(api.AbstractCodeExtension().fqn(), api.ICode().fqn());
        this.addContainerElement(api.AbstractCodeTypeWithGeneric().fqn(), api.ICode().fqn());
        this.addContainerElement(api.AbstractCodeTypeWithGenericExtension().fqn(), api.ICode().fqn());
        this.addContainerElement(api.AbstractComposerField().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractComposerFieldExtension().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractCompositeField().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractCompositeFieldExtension().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractDataModel().fqn(), api.IDataModelAttribute().fqn());
        this.addContainerElement(api.AbstractDataModel().fqn(), api.IDataModelEntity().fqn());
        this.addContainerElement(api.AbstractDataModelEntity().fqn(), api.IDataModelAttribute().fqn());
        this.addContainerElement(api.AbstractDataModelEntity().fqn(), api.IDataModelEntity().fqn());
        this.addContainerElement(api.AbstractDataModelEntityExtension().fqn(), api.IDataModelAttribute().fqn());
        this.addContainerElement(api.AbstractDataModelEntityExtension().fqn(), api.IDataModelEntity().fqn());
        this.addContainerElement(api.AbstractDesktop().fqn(), api.IAction().fqn());
        this.addContainerElement(api.AbstractDesktopExtension().fqn(), api.IAction().fqn());
        this.addContainerElement(api.AbstractExtension().fqn(), api.IExtension().fqn());
        this.addContainerElement(api.AbstractForm().fqn(), api.IFormHandler().fqn());
        this.addContainerElement(api.AbstractFormExtension().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractFormExtension().fqn(), api.IFormHandler().fqn());
        this.addContainerElement(api.AbstractFormField().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractFormFieldExtension().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractGroup().fqn(), api.IWidget().fqn());
        this.addContainerElement(api.AbstractGroupExtension().fqn(), api.IWidget().fqn());
        this.addContainerElement(api.AbstractGroupBox().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractGroupBoxExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractImageField().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractImageFieldExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractListBox().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractListBox().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractListBoxExtension().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractListBoxExtension().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractModeSelectorField().fqn(), api.IMode().fqn());
        this.addContainerElement(api.AbstractPageWithTable().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractPageWithTableExtension().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractRadioButtonGroup().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractRadioButtonGroupExtension().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractTabBox().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTabBoxExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTable().fqn(), api.IColumn().fqn());
        this.addContainerElement(api.AbstractTable().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractTable().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTable().fqn(), api.ITableControl().fqn());
        this.addContainerElement(api.AbstractTableExtension().fqn(), api.IColumn().fqn());
        this.addContainerElement(api.AbstractTableExtension().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractTableExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTableExtension().fqn(), api.ITableControl().fqn());
        this.addContainerElement(api.AbstractTableField().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractTableFieldExtension().fqn(), api.ITable().fqn());
        this.addContainerElement(api.AbstractTileField().fqn(), api.ITileGrid().fqn());
        this.addContainerElement(api.AbstractTileFieldExtension().fqn(), api.ITileGrid().fqn());
        this.addContainerElement(api.AbstractTileGrid().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTileGrid().fqn(), api.ITile().fqn());
        this.addContainerElement(api.AbstractTileGridExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTileGridExtension().fqn(), api.ITile().fqn());
        this.addContainerElement(api.AbstractTree().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractTree().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTreeExtension().fqn(), api.IKeyStroke().fqn());
        this.addContainerElement(api.AbstractTreeExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTreeBox().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractTreeBox().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractTreeBoxExtension().fqn(), api.IFormField().fqn());
        this.addContainerElement(api.AbstractTreeBoxExtension().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractTreeField().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractTreeFieldExtension().fqn(), api.ITree().fqn());
        this.addContainerElement(api.AbstractTreeNode().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractTreeNodeExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractValueField().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractValueFieldExtension().fqn(), api.IMenu().fqn());
        this.addContainerElement(api.AbstractWizard().fqn(), api.IWizardStep().fqn());
        this.addContainerElement(api.AbstractWizardExtension().fqn(), api.IWizardStep().fqn());
        this.addContainerElement(api.IContextMenuOwner().fqn(), api.IMenu().fqn());
        this.addInterfaceSuperType(api.IAccordion().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.IAccordionField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.IAction().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IAction().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.IActionNode().fqn(), api.IAction().fqn());
        this.addInterfaceSuperType(api.IBigDecimalField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IBooleanField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IBrowserField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.IButton().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IButton().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.ICalendar().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.ICalendar().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.ICalendarField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.ICode().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.ICode().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.ICodeType().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IColumn().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IColumn().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.ICompositeField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.ICompositeFieldExtension().fqn(), api.IFormFieldExtension().fqn());
        this.addInterfaceSuperType(api.IDataModelAttribute().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IDataModelAttribute().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IDataModelEntity().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IDataModelEntity().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IDateField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IDesktop().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IDesktop().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.IDesktopExtension().fqn(), api.IExtension().fqn());
        this.addInterfaceSuperType(api.IFileChooserButton().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IFileChooserField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IFormExtension().fqn(), api.IExtension().fqn());
        this.addInterfaceSuperType(api.IFormField().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IFormField().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.IFormFieldExtension().fqn(), api.IExtension().fqn());
        this.addInterfaceSuperType(api.IGroup().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IGroup().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.IGroupBox().fqn(), api.ICompositeField().fqn());
        this.addInterfaceSuperType(api.IGroupBox().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IHtmlField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IImageField().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IImageField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.IKeyStroke().fqn(), api.IAction().fqn());
        this.addInterfaceSuperType(api.ILabelField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IListBox().fqn(), api.ICompositeField().fqn());
        this.addInterfaceSuperType(api.IListBox().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.ILongField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IMenu().fqn(), api.IActionNode().fqn());
        this.addInterfaceSuperType(api.IMode().fqn(), api.IAction().fqn());
        this.addInterfaceSuperType(api.IModeSelectorField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IOutline().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IOutline().fqn(), api.ITree().fqn());
        this.addInterfaceSuperType(api.IPage().fqn(), api.ITreeNode().fqn());
        this.addInterfaceSuperType(api.IPage().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IPageWithNodes().fqn(), api.IPage().fqn());
        this.addInterfaceSuperType(api.IPageWithTable().fqn(), api.IPage().fqn());
        this.addInterfaceSuperType(api.IPageWithTableExtension().fqn(), api.IExtension().fqn());
        this.addInterfaceSuperType(api.IProposalField().fqn(), api.ISmartField().fqn());
        this.addInterfaceSuperType(api.IRadioButton().fqn(), api.IButton().fqn());
        this.addInterfaceSuperType(api.IRadioButtonGroup().fqn(), api.ICompositeField().fqn());
        this.addInterfaceSuperType(api.IRadioButtonGroup().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.ISequenceBox().fqn(), api.ICompositeField().fqn());
        this.addInterfaceSuperType(api.ISmartField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.IStringField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.ITabBox().fqn(), api.ICompositeField().fqn());
        this.addInterfaceSuperType(api.ITabBox().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.ITable().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.ITable().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.ITableControl().fqn(), api.IAction().fqn());
        this.addInterfaceSuperType(api.ITableExtension().fqn(), api.IExtension().fqn());
        this.addInterfaceSuperType(api.ITableField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.ITagField().fqn(), api.IValueField().fqn());
        this.addInterfaceSuperType(api.ITile().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.ITile().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.ITileField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.ITileGrid().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.ITileGrid().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.ITree().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.ITree().fqn(), api.IWidget().fqn());
        this.addInterfaceSuperType(api.ITreeField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.ITreeNode().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IValueField().fqn(), api.IContextMenuOwner().fqn());
        this.addInterfaceSuperType(api.IValueField().fqn(), api.IFormField().fqn());
        this.addInterfaceSuperType(api.IViewButton().fqn(), api.IAction().fqn());
        this.addInterfaceSuperType(api.IWidget().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IWizard().fqn(), api.ITypeWithClassId().fqn());
        this.addInterfaceSuperType(api.IWizardStep().fqn(), api.IOrdered().fqn());
        this.addInterfaceSuperType(api.IWizardStep().fqn(), api.ITypeWithClassId().fqn());
    }

    public IScoutApi api() {
        return this.m_api;
    }

    private void addContainerElement(String container, String possibleChild) {
        ScoutModelHierarchy.addToMapSet(container, possibleChild, this.m_childrenByContainer, 3);
    }

    private void addInterfaceSuperType(String ifc, String superTypeIfc) {
        ScoutModelHierarchy.addToMapSet(ifc, superTypeIfc, this.m_interfaceHierarchy, 3);
    }

    protected static void addToMapSet(String first, String second, Map<String, Set<String>> store, int initialSetSize) {
        store.computeIfAbsent(first, k -> new HashSet(initialSetSize)).add(second);
    }

    public Set<String> possibleChildrenFor(Collection<String> superTypesOfDeclaringType) {
        if (superTypesOfDeclaringType.contains(this.m_api.AbstractTabBox().fqn()) || superTypesOfDeclaringType.contains(this.m_api.AbstractTabBoxExtension().fqn())) {
            HashSet<String> possibleChildrenIfcFqn = new HashSet<String>(3);
            possibleChildrenIfcFqn.add(this.m_api.IGroupBox().fqn());
            possibleChildrenIfcFqn.add(this.m_api.IMenu().fqn());
            possibleChildrenIfcFqn.add(this.m_api.IKeyStroke().fqn());
            return possibleChildrenIfcFqn;
        }
        if (superTypesOfDeclaringType.contains(this.m_api.AbstractListBox().fqn()) || superTypesOfDeclaringType.contains(this.m_api.AbstractTreeBox().fqn()) || superTypesOfDeclaringType.contains(this.m_api.AbstractListBoxExtension().fqn()) || superTypesOfDeclaringType.contains(this.m_api.AbstractTreeBoxExtension().fqn())) {
            HashSet<String> possibleChildrenIfcFqn = new HashSet<String>(2);
            possibleChildrenIfcFqn.add(this.m_api.IMenu().fqn());
            possibleChildrenIfcFqn.add(this.m_api.IKeyStroke().fqn());
            return possibleChildrenIfcFqn;
        }
        if (superTypesOfDeclaringType.contains(this.m_api.AbstractRadioButtonGroup().fqn()) || superTypesOfDeclaringType.contains(this.m_api.AbstractRadioButtonGroupExtension().fqn())) {
            HashSet<String> possibleChildrenIfcFqn = new HashSet<String>(3);
            possibleChildrenIfcFqn.add(this.m_api.IRadioButton().fqn());
            possibleChildrenIfcFqn.add(this.m_api.IMenu().fqn());
            possibleChildrenIfcFqn.add(this.m_api.IKeyStroke().fqn());
            return possibleChildrenIfcFqn;
        }
        return superTypesOfDeclaringType.stream().flatMap(this::getPossibleChildren).collect(Collectors.toSet());
    }

    protected Stream<String> getPossibleChildren(String superClass) {
        Set<String> children = this.m_childrenByContainer.get(superClass);
        if (children == null || children.isEmpty()) {
            return Stream.empty();
        }
        return children.stream();
    }

    public boolean isSubtypeOf(String scoutTypeFqn, String scoutSuperTypeFqn) {
        if (Objects.equals(scoutTypeFqn, scoutSuperTypeFqn)) {
            return true;
        }
        Set<String> directSuperTypes = this.m_interfaceHierarchy.get(scoutTypeFqn);
        return directSuperTypes != null && !directSuperTypes.isEmpty() && this.isSubtypeOfRec(scoutSuperTypeFqn, directSuperTypes);
    }

    protected boolean isSubtypeOfRec(String scoutTypeFqn, Collection<String> directSuperTypes) {
        if (directSuperTypes.contains(scoutTypeFqn)) {
            return true;
        }
        for (String s : directSuperTypes) {
            boolean found = this.isSubtypeOf(s, scoutTypeFqn);
            if (!found) continue;
            return true;
        }
        return false;
    }
}

