/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class UrlUtil {
    static char[] ALLOWED_IN_FRAGMENT = "/?:@-.~!$&'()*+,;=_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    static {
        Arrays.sort(ALLOWED_IN_FRAGMENT);
    }

    public static String escapeUrlFormParameters(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static String escapeUrlFragment(String text) {
        int pos = -1;
        int i = 0;
        int l = text.length();
        while (i < l) {
            if (Arrays.binarySearch(ALLOWED_IN_FRAGMENT, text.charAt(i)) < 0) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            return text;
        }
        String head = text.substring(0, pos);
        String tail = text.substring(pos);
        tail = URLEncoder.encode(tail, StandardCharsets.UTF_8).replace("+", "%20");
        return head + tail;
    }
}

