/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.builder;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class SourceCollector<T extends ISourceGenerator<ISourceBuilder<?>>>
implements Collector<T, ISourceBuilder<?>, ISourceBuilder<?>> {
    private final ISourceBuilder<?> m_target;
    private final BiConsumer<ISourceBuilder<?>, T> m_appender;
    private final Set<Collector.Characteristics> m_characteristics;
    private Function<ISourceBuilder<?>, ISourceBuilder<?>> m_finisher;
    private BiConsumer<ISourceBuilder<?>, T> m_appenderForNextElement;

    public SourceCollector(ISourceBuilder<?> target, CharSequence prefix, CharSequence delim, CharSequence suffix) {
        this.m_target = Ensure.notNull(target);
        boolean hasSuffix = !Strings.isEmpty(suffix);
        boolean hasDelimiter = !Strings.isEmpty(delim);
        this.m_appender = hasDelimiter ? (a, b) -> target.append(delim).append((ISourceGenerator<ISourceBuilder<?>>)b) : (a, b) -> target.append((ISourceGenerator<ISourceBuilder<?>>)b);
        this.m_finisher = Function.identity();
        this.m_characteristics = hasSuffix ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
        this.m_appenderForNextElement = (builder, b) -> {
            if (!Strings.isEmpty(prefix)) {
                builder.append(prefix);
            }
            if (hasSuffix) {
                this.m_finisher = finishBuilder -> finishBuilder.append(suffix);
            }
            builder.append((ISourceGenerator<ISourceBuilder<?>>)b);
            this.m_appenderForNextElement = this.m_appender;
        };
    }

    @Override
    public Supplier<ISourceBuilder<?>> supplier() {
        return () -> this.m_target;
    }

    @Override
    public BiConsumer<ISourceBuilder<?>, T> accumulator() {
        return (a, b) -> this.m_appenderForNextElement.accept((ISourceBuilder<?>)a, (ISourceBuilder)((Object)b));
    }

    @Override
    public BinaryOperator<ISourceBuilder<?>> combiner() {
        return (left, right) -> {
            throw new UnsupportedOperationException("Parallel streams are not supported");
        };
    }

    @Override
    public Function<ISourceBuilder<?>, ISourceBuilder<?>> finisher() {
        return a -> this.m_finisher.apply((ISourceBuilder<?>)a);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.m_characteristics;
    }
}

