/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IIntLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.IntConstant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;

public class IntLiteral
extends NumberLiteral
implements IIntLiteral {
    public int value;
    static final Constant FORMAT_ERROR = DoubleConstant.fromValue(Double.POSITIVE_INFINITY);

    public IntLiteral(char[] token, int s, int e) {
        super(token, s, e);
    }

    public IntLiteral(char[] token, int s, int e, int value) {
        this(token, s, e);
        this.value = value;
    }

    public IntLiteral(int intValue) {
        super(null, 0, 0);
        this.constant = IntConstant.fromValue(intValue);
        this.value = intValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void computeConstant() {
        block9: {
            block8: {
                length = this.source.length;
                computedValue = 0L;
                if (this.source[0] != '0') break block8;
                if (length == 1) {
                    this.constant = IntConstant.fromValue(0);
                    return;
                }
                maxDigit = 16;
                if (this.source[1] == 'x' || this.source[1] == 'X') {
                    shift = 4;
                    j = 2;
                    radix = 16;
                    maxDigit = 18;
                } else {
                    shift = 3;
                    j = 1;
                    radix = 8;
                }
                if (length <= maxDigit) ** GOTO lbl23
                return;
lbl-1000:
                // 1 sources

                {
                    if (++j != length) continue;
                    this.value = (int)computedValue;
                    this.constant = IntConstant.fromValue(this.value);
                    return;
lbl23:
                    // 2 sources

                    ** while (this.source[j] == '0')
                }
lbl24:
                // 2 sources

                while (j < length) {
                    if ((digitValue = ScannerHelper.digit(this.source[j++], radix)) < 0) {
                        this.constant = IntLiteral.FORMAT_ERROR;
                        return;
                    }
                    computedValue = computedValue << shift | (long)digitValue;
                }
                break block9;
            }
            i = 0;
            while (i < length) {
                digitValue = ScannerHelper.digit(this.source[i], 10);
                if (digitValue < 0) {
                    this.constant = IntLiteral.FORMAT_ERROR;
                    return;
                }
                computedValue = 10L * computedValue + (long)digitValue;
                ++i;
            }
        }
        this.value = (int)computedValue;
        this.constant = IntConstant.fromValue(this.value);
    }

    @Override
    public TypeBinding literalType(BlockScope scope) {
        if (scope == null) {
            return TypeBinding.INT;
        }
        return scope.getJavaLangNumber();
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.source.length == 10 && this.source[0] == '2' && this.source[1] == '1' && this.source[2] == '4' && this.source[3] == '7' && this.source[4] == '4' && this.source[5] == '8' && this.source[6] == '3' && this.source[7] == '6' && this.source[8] == '4' && this.source[9] == '8' && (this.bits & 0x1FE00000) >> 21 == 0;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding tb = super.resolveType(scope);
        if (this.constant == FORMAT_ERROR) {
            this.constant = Constant.NotAConstant;
            scope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return tb;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.source == null) {
            return output.append(String.valueOf(this.value));
        }
        return super.printExpression(indent, output);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 49;
    }

    public static IntLiteral getOne() {
        return new IntLiteral(new char[]{'1'}, 0, 0, 1);
    }
}

