/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.sources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IProjectFragmentTimestamp;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.internal.environment.EFSFileHandle;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesElement;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesUtils;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.emf.common.util.EList;

public class TclSourcesFragment
extends Openable
implements IProjectFragment,
IProjectFragmentTimestamp {
    public static final IPath PATH = new Path("#special#sources#");
    private IPath currentPath;

    public TclSourcesFragment(ScriptProject project) {
        super((ModelElement)project);
        this.currentPath = PATH.append(project.getElementName()).append("@");
    }

    public String getElementName() {
        return this.currentPath.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TclSourcesFragment)) {
            return false;
        }
        TclSourcesFragment other = (TclSourcesFragment)((Object)o);
        return this.currentPath.equals((Object)other.currentPath) && this.parent.equals((Object)other.parent);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        ArrayList<TclSourcesElement> children = new ArrayList<TclSourcesElement>(1);
        children.add(new TclSourcesElement((ModelElement)this));
        info.setChildren(children.toArray(new IModelElement[children.size()]));
        return true;
    }

    public Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)this.getScriptFolder(classFileName);
                return classFile.getHandleFromMemento(memento, owner);
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento((MementoTokenizer)memento, (IParent)this, (WorkingCopyOwner)owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '}';
    }

    public void printNode(CorePrinter output) {
    }

    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
    }

    public IScriptFolder createScriptFolder(String name, boolean force, IProgressMonitor monitor) throws ModelException {
        return null;
    }

    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws ModelException {
    }

    public Object[] getForeignResources() throws ModelException {
        return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
    }

    public int getKind() throws ModelException {
        return 1;
    }

    public IBuildpathEntry getRawBuildpathEntry() throws ModelException {
        return null;
    }

    public IScriptFolder getScriptFolder(IPath path) {
        if (path.segmentCount() != 1) {
            return new TclSourcesElement((ModelElement)this, path.toString());
        }
        String name = path.segment(0);
        return this.getScriptFolder(name);
    }

    public IScriptFolder getScriptFolder(String name) {
        block4: {
            try {
                IModelElement[] elements = this.getChildren();
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getElementName().equals(name)) {
                        return (IScriptFolder)elements[i];
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new TclSourcesElement((ModelElement)this, name);
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isBuiltin() {
        return false;
    }

    public boolean exists() {
        return true;
    }

    public boolean isExternal() {
        return true;
    }

    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling, IProgressMonitor monitor) throws ModelException {
    }

    public int getElementType() {
        return 3;
    }

    public IPath getPath() {
        return this.currentPath;
    }

    public IResource getResource() {
        return null;
    }

    public long getTimeStamp() {
        long hash = 0L;
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this);
        List<TclModuleInfo> modules = TclPackagesManager.getProjectModules(this.getScriptProject().getElementName());
        for (TclModuleInfo tclModuleInfo : modules) {
            for (TclSourceEntry info : tclModuleInfo.getSourced()) {
                if (info.getValue() == null) continue;
                hash += hash * 31L + (long)info.getValue().hashCode() >> 2;
            }
            for (UserCorrection correction : tclModuleInfo.getSourceCorrections()) {
                if (correction.getOriginalValue() != null) {
                    hash += hash * 29L + (long)correction.getOriginalValue().hashCode() >> 2;
                }
                EList<String> uval = correction.getUserValue();
                for (String val : uval) {
                    hash += hash * 29L + (long)val.hashCode() >> 2;
                    IFileHandle file = env.getFile((IPath)new Path(val));
                    if (file == null) continue;
                    long lmodif = 0L;
                    lmodif = file instanceof EFSFileHandle ? ((EFSFileHandle)file).lastModified() : file.lastModified();
                    hash += lmodif;
                }
            }
        }
        return hash;
    }

    public boolean containChildrens() {
        IInterpreterInstall install = null;
        try {
            install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.getScriptProject());
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        if (install == null) {
            return false;
        }
        HashSet<IPath> sources = new HashSet<IPath>();
        HashSet<String> pseudoElements = new HashSet<String>();
        TclSourcesUtils.fillSources(install, this.getScriptProject(), sources, null, pseudoElements);
        return !sources.isEmpty() || !pseudoElements.isEmpty();
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }
}

