/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.formatter;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.formatter.AbstractScriptFormatterFactory;
import org.eclipse.dltk.tcl.formatter.TclFormatter;
import org.eclipse.dltk.tcl.formatter.preferences.TclFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.preferences.PreferenceKey;

public class TclFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final String[] KEYS = new String[]{"formatter.tabulation.char", "formatter.indentation.size", "formatter.tabulation.size", "indent.script", "indent.after.backslash", "lines.preserve", "line.file.require.after", "line.file.proc.between", "wrap.comments", "wrap.comments.length"};

    public IScriptFormatter createFormatter(String lineDelimiter, Map<String, String> preferences) {
        return new TclFormatter(lineDelimiter, preferences);
    }

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            String qualifier = "formatter.tabulation.char".equals(key) || "formatter.indentation.size".equals(key) || "formatter.tabulation.size".equals(key) ? "org.eclipse.dltk.tcl.ui" : "org.eclipse.dltk.tcl.formatter";
            result[i] = new PreferenceKey(qualifier, key);
            ++i;
        }
        return result;
    }

    public Map<String, String> changeToIndentingOnly(Map<String, String> preferences) {
        HashMap<String, String> result = new HashMap<String, String>(preferences);
        result.put("line.file.require.after", String.valueOf(-1));
        result.put("line.file.proc.between", String.valueOf(-1));
        result.put("lines.preserve", String.valueOf(-1));
        result.put("wrap.comments", String.valueOf(false));
        return result;
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new TclFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("preferences/formatterPreview.txt");
    }

    public PreferenceKey getActiveProfileKey() {
        return new PreferenceKey("org.eclipse.dltk.tcl.formatter", "formatter.profiles");
    }

    public PreferenceKey getProfilesKey() {
        return new PreferenceKey("org.eclipse.dltk.tcl.formatter", "formatter.profiles.active");
    }
}

