/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.console;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.RemoveAllTerminatedAction;
import org.eclipse.dltk.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.texteditor.IUpdate;

public class ConsoleRemoveAllTerminatedAction
extends Action
implements IUpdate,
ILaunchesListener2 {
    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void update() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.isTerminated()) {
                this.setEnabled(true);
                return;
            }
            ++i;
        }
        this.setEnabled(false);
    }

    public void run() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        RemoveAllTerminatedAction.removeTerminatedLaunches((ILaunch[])launches);
    }

    public ConsoleRemoveAllTerminatedAction() {
        super(ConsoleMessages.ConsoleRemoveAllTerminatedAction_0);
        this.setToolTipText(ConsoleMessages.ConsoleRemoveAllTerminatedAction_1);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_REMOVE_ALL"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_REMOVE_ALL"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_REMOVE_ALL"));
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        this.update();
    }

    public void launchesRemoved(ILaunch[] launches) {
        if (this.isEnabled()) {
            this.update();
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.update();
    }
}

