/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.Checks;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptorComment;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.RenameScriptFolderChange;
import org.eclipse.dltk.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameScriptFolderProcessor
extends ScriptRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    private static final String ID_RENAME_PACKAGE = "org.eclipse.dltk.ui.rename.script.folder";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private IScriptFolder fPackage;
    private TextChangeManager fChangeManager;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private boolean fRenameSubpackages;
    public static final String IDENTIFIER = "org.eclipse.dltk.ui.renamePackageProcessor";

    static {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: RenameScriptFolderProcessor add import manager supprot code here...");
        }
    }

    public RenameScriptFolderProcessor(IScriptFolder fragment) {
        this.fPackage = fragment;
        if (this.fPackage != null) {
            this.setNewElementName(this.fPackage.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameSubpackages = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fPackage);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenamePackageRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fPackage);
    }

    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fPackage, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), this.fRenameSubpackages);
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        HashSet<IFile> combined = new HashSet<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles((ISourceModule[])this.fChangeManager.getAllSourceModules())));
        if (this.fRenameSubpackages) {
            IScriptFolder[] allPackages = ModelElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < allPackages.length) {
                combined.addAll(Arrays.asList(ResourceUtil.getFiles((ISourceModule[])allPackages[i].getSourceModules())));
                ++i;
            }
        } else {
            combined.addAll(Arrays.asList(ResourceUtil.getFiles((ISourceModule[])this.fPackage.getSourceModules())));
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: RenameScriptFolderProcessor Add fQualifiedNameSearchResult suppor code");
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isRootFolder();
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    @Override
    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    @Override
    public void setFilePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        this.fFilePatterns = patterns;
    }

    public boolean canEnableRenameSubpackages() throws ModelException {
        return this.fPackage.hasSubfolders();
    }

    public boolean getRenameSubpackages() {
        return this.fRenameSubpackages;
    }

    public void setRenameSubpackages(boolean rename) {
        this.fRenameSubpackages = rename;
    }

    @Override
    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    @Override
    public String getCurrentElementQualifier() {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add correct package name validation here...");
        }
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (Checks.isAlreadyNamed((IModelElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenamePackageRefactoring_another_name);
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    public Object getNewElement() {
        IModelElement parent = this.fPackage.getParent();
        if (!(parent instanceof IProjectFragment)) {
            return this.fPackage;
        }
        IProjectFragment root = (IProjectFragment)parent;
        return root.getScriptFolder(this.getNewElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            String message;
            pm.beginTask("", 23 + (this.fUpdateQualifiedNames ? 10 : 0));
            pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            pm.worked(2);
            if (this.fPackage.isReadOnly()) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_Packagered_only, this.fPackage.getElementName());
                result.addFatalError(message);
            } else if (Resources.isReadOnly(this.fPackage.getResource())) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_resource_read_only, this.fPackage.getElementName());
                result.addError(message);
            }
            result.merge(this.checkPackageName(this.getNewElementName()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fChangeManager = new TextChangeManager();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 16);
            if (this.fRenameSubpackages) {
                IScriptFolder[] allSubpackages = ModelElementUtil.getPackageAndSubpackages(this.fPackage);
                subPm.beginTask("", allSubpackages.length);
                int i = 0;
                while (i < allSubpackages.length) {
                    new PackageRenamer(allSubpackages[i], this, this.fChangeManager).doRename((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), result);
                    ++i;
                }
                subPm.done();
            } else {
                new PackageRenamer(this.fPackage, this, this.fChangeManager).doRename((IProgressMonitor)subPm, result);
            }
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add updating of fUpdateQualifiedNames");
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public IScriptFolder getPackage() {
        return this.fPackage;
    }

    public static boolean isPackageNameOkInRoot(String newName, IProjectFragment root) throws CoreException {
        IScriptFolder pack = root.getScriptFolder(newName);
        if (!pack.exists()) {
            return true;
        }
        if (!pack.hasSubfolders()) {
            return false;
        }
        if (pack.containsScriptResources()) {
            return false;
        }
        return pack.getForeignResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws CoreException {
        if (RenameScriptFolderProcessor.isPackageNameOkInRoot(newName, this.getProjectFragment())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
    }

    private IProjectFragment getProjectFragment() {
        return (IProjectFragment)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IProjectFragment[] roots = this.fPackage.getScriptProject().getProjectFragments();
        Set topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            if (!RenameScriptFolderProcessor.isPackageNameOkInRoot(newName, roots[i])) {
                String message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_aleady_exists, this.getNewElementName(), roots[i].getElementName());
                status.merge(RefactoringStatus.createWarningStatus((String)message));
                status.merge(this.checkTypeNameConflicts(roots[i], newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set getTopLevelTypeNames() throws CoreException {
        ISourceModule[] cus = this.fPackage.getSourceModules();
        HashSet result = new HashSet(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenameScriptFolderProcessor.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection getTopLevelTypeNames(ISourceModule iSourceModule) throws CoreException {
        IType[] types = iSourceModule.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IProjectFragment root, String newName, Set topLevelTypeNames) throws CoreException {
        IScriptFolder otherPack = root.getScriptFolder(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ISourceModule[] cus = otherPack.getSourceModules();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ISourceModule iSourceModule, Set topLevelTypeNames) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iSourceModule.getTypes();
        String packageName = iSourceModule.getParent().getElementName();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                Object[] keys = new Object[]{packageName, name};
                String msg = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_contains_type, keys);
                RefactoringStatusContext context = ScriptStatusContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenamePackageRefactoring_creating_change, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IScriptProject scriptProject = this.fPackage.getScriptProject();
            if (scriptProject != null) {
                project = scriptProject.getElementName();
            }
            int flags = 589830;
            String description = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description_short, this.fPackage.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description, this.fPackage.getElementName(), this.getNewElementName());
            ScriptRefactoringDescriptorComment comment = new ScriptRefactoringDescriptorComment(this, header);
            if (this.fRenameSubpackages) {
                comment.addSetting(RefactoringCoreMessages.RenamePackageProcessor_rename_subpackages);
            }
            ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor(ID_RENAME_PACKAGE, project, description, comment.asString(), arguments, 589830);
            arguments.put("input", descriptor.elementToHandle((IModelElement)this.fPackage));
            arguments.put("name", this.getNewElementName());
            if (this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
                arguments.put(ATTRIBUTE_PATTERNS, this.fFilePatterns);
            }
            arguments.put(ATTRIBUTE_REFERENCES, Boolean.valueOf(this.fUpdateReferences).toString());
            arguments.put(ATTRIBUTE_QUALIFIED, Boolean.valueOf(this.fUpdateQualifiedNames).toString());
            arguments.put(ATTRIBUTE_TEXTUAL_MATCHES, Boolean.valueOf(this.fUpdateTextualMatches).toString());
            arguments.put(ATTRIBUTE_HIERARCHICAL, Boolean.valueOf(this.fRenameSubpackages).toString());
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((RefactoringDescriptor)descriptor, RefactoringCoreMessages.RenamePackageRefactoring_change_name);
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            result.add((Change)new RenameScriptFolderChange(null, this.fPackage, this.getNewElementName(), comment.asString(), this.fRenameSubpackages));
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeManager = null;
            monitor.done();
        }
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        return null;
    }

    public String getNewPackageName(String oldSubPackageName) {
        String oldPackageName = this.getPackage().getElementName();
        return String.valueOf(this.getNewElementName()) + oldSubPackageName.substring(oldPackageName.length());
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String hierarchical;
        if (arguments instanceof ScriptRefactoringArguments) {
            IModelElement element;
            ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = ScriptRefactoringDescriptor.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
                if (element == null || !element.exists() || element.getElementType() != 4) {
                    return ScriptableRefactoring.createInputFatalStatus((Object)element, (String)this.getRefactoring().getName(), (String)ID_RENAME_PACKAGE);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fPackage = (IScriptFolder)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
            this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
            String references = extended.getAttribute(ATTRIBUTE_REFERENCES);
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REFERENCES));
            }
            this.fUpdateReferences = Boolean.valueOf(references);
            String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
            if (matches == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
            }
            this.fUpdateTextualMatches = Boolean.valueOf(matches);
            String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
            if (qualified == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
            hierarchical = extended.getAttribute(ATTRIBUTE_HIERARCHICAL);
            if (hierarchical == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_HIERARCHICAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fRenameSubpackages = Boolean.valueOf(hierarchical);
        return new RefactoringStatus();
    }

    private static class PackageRenamer {
        private final IScriptFolder fPackage;
        private final RenameScriptFolderProcessor fProcessor;

        public PackageRenamer(IScriptFolder pack, RenameScriptFolderProcessor processor, TextChangeManager textChangeManager) {
            this.fPackage = pack;
            this.fProcessor = processor;
        }

        void doRename(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
            pm.beginTask("", 16 + (this.fProcessor.getUpdateTextualMatches() ? 10 : 0));
            if (this.fProcessor.getUpdateReferences()) {
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_searching);
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                result.merge(this.analyzeAffectedSourceModules());
                pm.worked(1);
            } else {
                pm.worked(13);
            }
            if (result.hasFatalError()) {
                return;
            }
            if (this.fProcessor.getUpdateReferences()) {
                this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            if (this.fProcessor.getUpdateTextualMatches() && this.fPackage.equals(this.fProcessor.getPackage())) {
                pm.subTask(RefactoringCoreMessages.RenamePackageRefactoring_searching_text);
            }
            pm.done();
        }

        private RefactoringStatus analyzeAffectedSourceModules() throws CoreException {
            RefactoringStatus result = new RefactoringStatus();
            if (result.hasFatalError()) {
                return result;
            }
            return result;
        }

        private void addReferenceUpdates(IProgressMonitor pm) throws CoreException {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add search support code.");
            }
            pm.done();
        }
    }
}

