/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.TclPackageDeclaration;

public class TclPackageProcessor
extends AbstractTclCommandProcessor
implements ITclCommandProcessor {
    @Override
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement.getCount() < 2) {
            this.report(parser, "Syntax error: at least one arguments expected.", (ASTNode)statement, ProblemSeverities.Error);
            if (DLTKCore.DEBUG) {
                System.err.println("tcl: package argument could incorrect...");
            }
            return null;
        }
        Expression nameSpaceArg = statement.getAt(1);
        if (nameSpaceArg == null || !(nameSpaceArg instanceof SimpleReference)) {
            this.report(parser, "Syntax error: package subcommand expected.", (ASTNode)(nameSpaceArg == null ? nameSpaceArg : statement), ProblemSeverities.Error);
            if (DLTKCore.DEBUG) {
                System.err.println("tcl: package argument is null or not simple reference");
            }
            return null;
        }
        String arg = ((SimpleReference)nameSpaceArg).getName();
        if (arg.equals("require") || arg.equals("provide")) {
            boolean exact = false;
            int i = 2;
            Expression pkg = statement.getAt(i);
            if (arg.equals("require") && pkg instanceof SimpleReference && "-exact".equals(((SimpleReference)pkg).getName())) {
                i = 3;
                pkg = statement.getAt(i);
            }
            Expression pkgVer = null;
            if (statement.getCount() > i + 1 && statement.getAt(i + 1) instanceof SimpleReference) {
                pkgVer = statement.getAt(i + 1);
            }
            if (pkg != null && pkg instanceof SimpleReference) {
                int style = -1;
                if (arg.equals("require")) {
                    style = 2;
                } else if (arg.equals("provide")) {
                    style = 0;
                }
                TclPackageDeclaration st = new TclPackageDeclaration((SimpleReference)pkg, (ASTNode)pkgVer, style, statement.sourceStart(), statement.sourceEnd());
                st.setExact(exact);
                this.addToParent(parent, (ASTNode)st);
                return st;
            }
        } else if (arg.equals("ifneeded")) {
            Expression pkg = statement.getAt(2);
            Expression pkgVer = null;
            Expression script = null;
            switch (statement.getCount()) {
                case 5: {
                    if (statement.getAt(4) instanceof TclBlockExpression) {
                        script = statement.getAt(4);
                    }
                    if (statement.getAt(4) instanceof Block) {
                        script = statement.getAt(4);
                    }
                }
                case 4: {
                    if (!(statement.getAt(3) instanceof SimpleReference)) break;
                    pkgVer = statement.getAt(3);
                    break;
                }
                default: {
                    this.report(parser, "Syntax error: 3 or 4 arguments expected.", (ASTNode)statement, ProblemSeverities.Error);
                    return null;
                }
            }
            if (pkg != null && pkg instanceof SimpleReference) {
                TclPackageDeclaration st = new TclPackageDeclaration((SimpleReference)pkg, (ASTNode)pkgVer, 1, statement.sourceStart(), statement.sourceEnd());
                st.setScript(script);
                this.addToParent(parent, (ASTNode)st);
                return st;
            }
        } else {
            arg.equals("forget");
        }
        return null;
    }
}

