/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;

public class ScriptConsolePartitioner
extends FastPartitioner
implements IConsoleDocumentPartitioner {
    private SortedSet<StyleRange> ranges = new TreeSet<StyleRange>((sr1, sr2) -> {
        int start = sr1.start - sr2.start;
        if (start == 0) {
            return sr1.length - sr2.length;
        }
        return start;
    });

    public ScriptConsolePartitioner() {
        super((IPartitionTokenScanner)new MyPartitionScanner(), new String[]{"__my_double", "__my_single"});
    }

    public void addRange(StyleRange r) {
        this.ranges.add(r);
    }

    public void addRanges(StyleRange[] r) {
        this.ranges.addAll(Arrays.asList(r));
    }

    public void clearRanges() {
        this.ranges.clear();
    }

    public StyleRange[] getStyleRanges(int offset, int length) {
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        StyleRange sr = new StyleRange(offset, 0, null, null, 128);
        for (StyleRange r : this.ranges.tailSet(sr)) {
            if (r.start < offset || r.start + r.length > offset + length) break;
            result.add((StyleRange)r.clone());
        }
        if (result.size() > 0) {
            return result.toArray(new StyleRange[result.size()]);
        }
        sr.length = length;
        return new StyleRange[]{sr};
    }

    public boolean isReadOnly(int offset) {
        return false;
    }

    private static class Constants {
        public static final String MY_DOUBLE_QUOTED = "__my_double";
        public static final String MY_SINGLE_QUOTED = "__my_single";

        private Constants() {
        }
    }

    private static class MyPartitionScanner
    extends RuleBasedPartitionScanner {
        public MyPartitionScanner() {
            Token myDouble = new Token((Object)"__my_double");
            Token mySingle = new Token((Object)"__my_single");
            ArrayList<MultiLineRule> rules = new ArrayList<MultiLineRule>();
            rules.add(new MultiLineRule("'", "'", (IToken)mySingle, '\\'));
            rules.add(new MultiLineRule("\"", "\"", (IToken)myDouble, '\\'));
            IPredicateRule[] result = new IPredicateRule[rules.size()];
            rules.toArray(result);
            this.setPredicateRules(result);
        }
    }
}

