/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.process;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.dltk.launching.process.ScriptRuntimeProcess;

public class ScriptRuntimeProcessFactory
implements IProcessFactory {
    public static final String PROCESS_FACTORY_ID = "org.eclipse.dltk.launching.scriptProcessFactory";

    private static boolean isDebugConsole(ILaunchConfiguration config) {
        try {
            return config.getAttribute("org.eclipse.dltk.launching.debugConsole", true);
        }
        catch (CoreException e) {
            return true;
        }
    }

    private static boolean isInteractiveConsole(ILaunchConfiguration config) {
        try {
            return config.getAttribute("use_dltk_interactive_console", false);
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static boolean isSupported(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if ("debug".equals(launch.getLaunchMode())) {
            return config != null && ScriptRuntimeProcessFactory.isDebugConsole(config);
        }
        return config != null && ScriptRuntimeProcessFactory.isInteractiveConsole(config);
    }

    public IProcess newProcess(ILaunch launch, Process process, String label, Map<String, String> attributes) {
        if (ScriptRuntimeProcessFactory.isSupported(launch)) {
            return new ScriptRuntimeProcess(launch, process, label, attributes);
        }
        return new RuntimeProcess(launch, process, label, attributes);
    }
}

