/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.search.DLTKMatchFilter;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.search.IMatchPresentation;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchFilter;
import org.eclipse.ui.IEditorPart;

public class DLTKSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private DLTKSearchQuery fQuery;
    private Map<Object, IMatchPresentation> fElementsToParticipants;
    private static final Match[] NO_MATCHES = new Match[0];

    public DLTKSearchResult(DLTKSearchQuery query) {
        this.fQuery = query;
        this.fElementsToParticipants = new HashMap<Object, IMatchPresentation>();
        this.setActiveMatchFilters(DLTKMatchFilter.getLastUsedFilters());
    }

    public ImageDescriptor getImageDescriptor() {
        return this.fQuery.getImageDescriptor();
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches((IAdaptable)editor.getEditorInput());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IAdaptable)file);
    }

    private Match[] computeContainedMatches(IAdaptable adaptable) {
        IFile file;
        IModelElement modelElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
        HashSet<Match> matches = new HashSet<Match>();
        if (modelElement != null) {
            this.collectMatches(matches, modelElement);
        }
        if ((file = (IFile)adaptable.getAdapter(IFile.class)) != null) {
            this.collectMatches(matches, file);
        }
        if (!matches.isEmpty()) {
            return matches.toArray(new Match[matches.size()]);
        }
        return NO_MATCHES;
    }

    private void collectMatches(Set<Match> matches, IFile element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
    }

    private void collectMatches(Set<Match> matches, IModelElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IModelElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            ISourceModule cu = (ISourceModule)modelElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getResource();
            }
            return null;
        }
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IModelElement) {
            return (element = ((IModelElement)element).getOpenable()) != null && element.equals(editor.getEditorInput().getAdapter(IModelElement.class));
        }
        if (element instanceof IFile) {
            return element.equals(editor.getEditorInput().getAdapter(IFile.class));
        }
        return false;
    }

    public MatchFilter[] getAllMatchFilters() {
        return DLTKMatchFilter.allFilters();
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    synchronized IMatchPresentation getSearchParticpant(Object element) {
        return this.fElementsToParticipants.get(element);
    }

    boolean addMatch(Match match, IMatchPresentation participant) {
        Object element = match.getElement();
        if (this.fElementsToParticipants.get(element) != null) {
            DLTKUIPlugin.log((IStatus)new Status(2, DLTKUIPlugin.getPluginId(), 0, "A second search participant was found for an element", null));
            return false;
        }
        this.fElementsToParticipants.put(element, participant);
        this.addMatch(match);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        DLTKSearchResult dLTKSearchResult = this;
        synchronized (dLTKSearchResult) {
            this.fElementsToParticipants.clear();
        }
        super.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMatch(Match match) {
        DLTKSearchResult dLTKSearchResult = this;
        synchronized (dLTKSearchResult) {
            if (this.getMatchCount(match.getElement()) == 1) {
                this.fElementsToParticipants.remove(match.getElement());
            }
        }
        super.removeMatch(match);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

