/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TableTextCellEditor
extends CellEditor {
    private final TableViewer fTableViewer;
    private final int fColumn;
    private final String fProperty;
    String fOriginalValue;
    SubjectControlContentAssistant fContentAssistant;
    private IActivationListener fActivationListener;
    protected Text text;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private static final int defaultStyle = 4;
    private ModifyListener fModifyListener;

    public TableTextCellEditor(TableViewer tableViewer, int column) {
        super((Composite)tableViewer.getTable(), 4);
        this.fTableViewer = tableViewer;
        this.fColumn = column;
        this.fProperty = (String)tableViewer.getColumnProperties()[column];
    }

    public void activate() {
        super.activate();
        if (this.fActivationListener != null) {
            this.fActivationListener.activate();
        }
        this.fOriginalValue = this.text.getText();
    }

    private void fireModifyEvent(Object newValue) {
        this.fTableViewer.getCellModifier().modify(((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement(), this.fProperty, newValue);
    }

    protected void focusLost() {
        if (this.fContentAssistant == null || !this.fContentAssistant.hasProposalPopupFocus()) {
            super.focusLost();
        }
    }

    public void setContentAssistant(SubjectControlContentAssistant assistant) {
        this.fContentAssistant = assistant;
    }

    public void setActivationListener(IActivationListener listener) {
        this.fActivationListener = listener;
    }

    public Text getText() {
        return this.text;
    }

    protected void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    protected void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    protected void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    private ModifyListener getModifyListener() {
        if (this.fModifyListener == null) {
            this.fModifyListener = e -> this.editOccured(e);
        }
        return this.fModifyListener;
    }

    protected Control createControl(Composite parent) {
        this.text = new Text(parent, this.getStyle());
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableTextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(e.stateMask != SWT.MOD1 && e.stateMask != SWT.MOD2 || e.keyCode != 0x1000001 && e.keyCode != 0x1000002)) {
                    TableTextCellEditor.this.deactivate();
                    e.doit = false;
                    return;
                }
                if (e.stateMask != 0) {
                    return;
                }
                switch (e.keyCode) {
                    case 0x1000002: {
                        e.doit = false;
                        int nextRow = TableTextCellEditor.this.fTableViewer.getTable().getSelectionIndex() + 1;
                        if (nextRow >= TableTextCellEditor.this.fTableViewer.getTable().getItemCount()) break;
                        this.editRow(nextRow);
                        break;
                    }
                    case 0x1000001: {
                        e.doit = false;
                        int prevRow = TableTextCellEditor.this.fTableViewer.getTable().getSelectionIndex() - 1;
                        if (prevRow < 0) break;
                        this.editRow(prevRow);
                        break;
                    }
                    case 0x100000B: {
                        e.doit = false;
                        TableTextCellEditor.this.deactivate();
                    }
                }
            }

            private void editRow(int row) {
                TableTextCellEditor.this.fTableViewer.getTable().setSelection(row);
                IStructuredSelection newSelection = (IStructuredSelection)TableTextCellEditor.this.fTableViewer.getSelection();
                if (newSelection.size() == 1) {
                    TableTextCellEditor.this.fTableViewer.editElement(newSelection.getFirstElement(), TableTextCellEditor.this.fColumn);
                }
            }
        });
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableTextCellEditor.this.keyReleaseOccured(e);
                if (TableTextCellEditor.this.getControl() == null || TableTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                e.display.asyncExec(() -> TableTextCellEditor.this.focusLost());
            }
        });
        this.text.setFont(parent.getFont());
        this.text.setBackground(parent.getBackground());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    protected void fireCancelEditor() {
        this.text.setText(this.fOriginalValue);
        super.fireApplyEditorValue();
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.text != null && value instanceof String ? 1 : 0) != 0);
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText((String)value);
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(value);
        if (!newValidState) {
            this.setErrorMessage(Messages.format(this.getErrorMessage(), new Object[]{value}));
        }
        this.valueChanged(oldValidState, newValidState);
        this.fireModifyEvent(this.text.getText());
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.text != null && !this.text.isDisposed() && (this.text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public static interface IActivationListener {
        public void activate();
    }
}

