/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathContainerExtension;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IBuiltinModuleProvider;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BuiltinProjectFragmentInfo;
import org.eclipse.dltk.internal.core.BuiltinScriptFolder;
import org.eclipse.dltk.internal.core.BuiltinScriptFolderInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;

public class BuiltinProjectFragment
extends ProjectFragment {
    static final Object INTERPRETER_CONTAINER = "org.eclipse.dltk.launching.INTERPRETER_CONTAINER";
    protected final IPath fPath;
    IBuiltinModuleProvider builtinProvider;

    protected BuiltinProjectFragment(IPath path, ScriptProject project) {
        super(null, project);
        this.fPath = path;
        this.builtinProvider = BuiltinProjectFragment.getBuiltinProvider(project);
    }

    public static IBuiltinModuleProvider getBuiltinProvider(IScriptProject project) {
        block7: {
            IPath containerPath;
            block6: {
                IBuildpathEntry[] entries = project.getRawBuildpath();
                containerPath = null;
                int i = 0;
                while (i < entries.length) {
                    IPath path;
                    if (entries[i].getEntryKind() == 5 && (path = entries[i].getPath()).segment(0).equals(INTERPRETER_CONTAINER)) {
                        containerPath = entries[i].getPath();
                        break;
                    }
                    ++i;
                }
                if (containerPath != null) break block6;
                return null;
            }
            try {
                IBuildpathContainer buildpathContainer = ModelManager.getModelManager().getBuildpathContainer(containerPath, project);
                if (buildpathContainer != null && buildpathContainer instanceof IBuildpathContainerExtension) {
                    return ((IBuildpathContainerExtension)buildpathContainer).getBuiltinProvider();
                }
            }
            catch (CoreException ex) {
                if (!DLTKCore.DEBUG) break block7;
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isSupported(IScriptProject project) {
        IBuiltinModuleProvider prov = BuiltinProjectFragment.getBuiltinProvider(project);
        return prov != null && prov.getBuiltinModules() != null;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        char[][] exclusionPatterns;
        ArrayList<IModelElement> vChildren = new ArrayList<IModelElement>(5);
        char[][] inclusionPatterns = this.fullInclusionPatternChars();
        this.computeFolderChildren(this.fPath, !Util.isExcluded(this.fPath, inclusionPatterns, exclusionPatterns = this.fullExclusionPatternChars(), true), vChildren, newElements, inclusionPatterns, exclusionPatterns);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected void computeFolderChildren(IPath path, boolean isIncluded, ArrayList<IModelElement> vChildren, Map newElements, char[][] inclusionPatterns, char[][] exclusionPatterns) throws ModelException {
        BuiltinScriptFolder fldr = (BuiltinScriptFolder)this.getScriptFolder((IPath)Path.EMPTY);
        vChildren.add(fldr);
        if (this.builtinProvider == null) {
            return;
        }
        try {
            BuiltinScriptFolderInfo fragInfo = new BuiltinScriptFolderInfo();
            fldr.computeChildren(fragInfo, this.builtinProvider.getBuiltinModules());
            fldr.computeForeignResources(fragInfo);
            newElements.put(fldr, fragInfo);
        }
        catch (IllegalArgumentException e) {
            throw new ModelException(e, 969);
        }
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        block4: {
            try {
                String portablePath = path.toPortableString();
                IModelElement[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    IModelElement child = children[i];
                    if (child.getElementType() == 4 && ((IScriptFolder)child).getElementName().equals(portablePath)) {
                        return (IScriptFolder)child;
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return new BuiltinScriptFolder(this, path);
    }

    @Override
    public IScriptFolder getScriptFolder(String path) {
        return this.getScriptFolder((IPath)new Path(path));
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected Object createElementInfo() {
        return new BuiltinProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public boolean isBuiltin() {
        return true;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        return null;
    }

    @Override
    public int hashCode() {
        return this.fPath.hashCode();
    }

    @Override
    public IPath getPath() {
        if (this.isExternal()) {
            return this.fPath;
        }
        return super.getPath();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected boolean resourceExists() {
        return true;
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BuiltinProjectFragment) {
            BuiltinProjectFragment other = (BuiltinProjectFragment)o;
            return this.fPath.equals((Object)other.fPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.fPath.toOSString().replace(File.separatorChar, '>');
    }

    @Override
    public void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = "";
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = "";
                    token = null;
                }
                ModelElement pkg = (ModelElement)((Object)this.getScriptFolder(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public IBuildpathEntry getRawBuildpathEntry() throws ModelException {
        IBuildpathEntry rawEntry = null;
        ScriptProject project = (ScriptProject)this.getScriptProject();
        project.getResolvedBuildpath();
        Map<IPath, IBuildpathEntry> rootPathToRawEntries = project.getPerProjectInfo().rootPathToRawEntries;
        if (rootPathToRawEntries != null) {
            rawEntry = rootPathToRawEntries.get(this.getPath());
        }
        if (rawEntry == null) {
            throw new ModelException(new ModelStatus(1006, this));
        }
        return rawEntry;
    }

    @Override
    public IBuildpathEntry getBuildpathEntry() throws ModelException {
        ScriptProject project = (ScriptProject)this.getScriptProject();
        IBuildpathEntry rawEntry = this.getRawBuildpathEntry();
        if (rawEntry != null && rawEntry.getEntryKind() == 5) {
            IBuildpathContainer container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), project);
            IBuildpathEntry[] entrys = container.getBuildpathEntries();
            int i = 0;
            while (i < entrys.length) {
                if (entrys[i].getPath().equals((Object)new Path(this.getPath().segment(0)))) {
                    return entrys[i];
                }
                ++i;
            }
        }
        return rawEntry;
    }

    @Override
    protected IStatus validateOnBuildpath() {
        return Status.OK_STATUS;
    }

    @Override
    public boolean exists() {
        return true;
    }

    public long lastModified() {
        return this.builtinProvider != null ? this.builtinProvider.lastModified() : 0L;
    }
}

