/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.codeassist;

import org.eclipse.dltk.codeassist.ICompletionNameProvider;
import org.eclipse.dltk.core.IMember;

public class CompletionNameProviders {
    private static final MemberCompletionNameProvider memberProvider = new MemberCompletionNameProvider();

    public static <T extends IMember> ICompletionNameProvider<T> defaultProvider() {
        return memberProvider;
    }

    public static <T extends IMember> ICompletionNameProvider<T> prefixProvider(String prefix) {
        if (prefix != null && prefix.length() != 0) {
            return new PrefixCompletionNameProvider(prefix);
        }
        return CompletionNameProviders.defaultProvider();
    }

    private static class MemberCompletionNameProvider
    implements ICompletionNameProvider<IMember> {
        private MemberCompletionNameProvider() {
        }

        @Override
        public String getCompletion(IMember t) {
            return t.getElementName();
        }

        @Override
        public String getName(IMember t) {
            return t.getElementName();
        }
    }

    private static class PrefixCompletionNameProvider
    implements ICompletionNameProvider<IMember> {
        final String prefix;

        public PrefixCompletionNameProvider(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String getCompletion(IMember t) {
            return t.getElementName();
        }

        @Override
        public String getName(IMember t) {
            return String.valueOf(this.prefix) + t.getElementName();
        }
    }
}

