/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.CopyProjectFragmentOperation;

public class MoveProjectFragmentOperation
extends CopyProjectFragmentOperation {
    protected void renameEntryInBuildpath(IPath rootPath, IScriptProject project) throws ModelException {
        IBuildpathEntry[] buildpath = project.getRawBuildpath();
        IBuildpathEntry[] newBuildpath = null;
        int cpLength = buildpath.length;
        int newCPIndex = -1;
        int i = 0;
        while (i < cpLength) {
            IBuildpathEntry entry = buildpath[i];
            IPath entryPath = entry.getPath();
            if (rootPath.equals((Object)entryPath)) {
                if (newBuildpath == null) {
                    newBuildpath = new IBuildpathEntry[cpLength];
                    System.arraycopy(buildpath, 0, newBuildpath, 0, i);
                    newCPIndex = i;
                }
                newBuildpath[newCPIndex++] = this.copy(entry);
            } else if (this.destination.equals((Object)entryPath)) {
                if (newBuildpath == null) {
                    newBuildpath = new IBuildpathEntry[cpLength];
                    System.arraycopy(buildpath, 0, newBuildpath, 0, i);
                    newCPIndex = i;
                }
            } else if (entry.getEntryKind() == 3) {
                IPath projectRelativePath = rootPath.removeFirstSegments(1);
                IPath[] newExclusionPatterns = this.renamePatterns(projectRelativePath, entry.getExclusionPatterns());
                IPath[] newInclusionPatterns = this.renamePatterns(projectRelativePath, entry.getInclusionPatterns());
                if (newExclusionPatterns != null || newInclusionPatterns != null) {
                    if (newBuildpath == null) {
                        newBuildpath = new IBuildpathEntry[cpLength];
                        System.arraycopy(buildpath, 0, newBuildpath, 0, i);
                        newCPIndex = i;
                    }
                    newBuildpath[newCPIndex++] = DLTKCore.newSourceEntry(entry.getPath(), newInclusionPatterns == null ? entry.getInclusionPatterns() : newInclusionPatterns, newExclusionPatterns == null ? entry.getExclusionPatterns() : newExclusionPatterns, entry.getExtraAttributes());
                } else if (newBuildpath != null) {
                    newBuildpath[newCPIndex++] = entry;
                }
            } else if (newBuildpath != null) {
                newBuildpath[newCPIndex++] = entry;
            }
            ++i;
        }
        if (newBuildpath != null) {
            IModelStatus status;
            if (newCPIndex < newBuildpath.length) {
                IBuildpathEntry[] iBuildpathEntryArray = newBuildpath;
                newBuildpath = new IBuildpathEntry[newCPIndex];
                System.arraycopy(iBuildpathEntryArray, 0, newBuildpath, 0, newCPIndex);
            }
            if ((status = BuildpathEntry.validateBuildpath(project, newBuildpath)).isOK()) {
                project.setRawBuildpath(newBuildpath, this.progressMonitor);
            }
        }
    }

    private IPath[] renamePatterns(IPath rootPath, IPath[] patterns) {
        IPath[] newPatterns = null;
        int newPatternsIndex = -1;
        int i = 0;
        int length = patterns.length;
        while (i < length) {
            IPath pattern = patterns[i];
            if (pattern.equals((Object)rootPath)) {
                if (newPatterns == null) {
                    newPatterns = new IPath[length];
                    System.arraycopy(patterns, 0, newPatterns, 0, i);
                    newPatternsIndex = i;
                }
                IPath newPattern = this.destination.removeFirstSegments(1);
                if (pattern.hasTrailingSeparator()) {
                    newPattern = newPattern.addTrailingSeparator();
                }
                newPatterns[newPatternsIndex++] = newPattern;
            }
            ++i;
        }
        return newPatterns;
    }

    public MoveProjectFragmentOperation(IProjectFragment root, IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling) {
        super(root, destination, updateResourceFlags, updateModelFlags, sibling);
    }

    @Override
    protected void executeOperation() throws ModelException {
        boolean updateDestination;
        IProjectFragment root = (IProjectFragment)this.getElementToProcess();
        IBuildpathEntry rootEntry = root.getRawBuildpathEntry();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.moveResource(root, rootEntry, workspaceRoot);
        }
        IScriptProject originatingProject = root.getScriptProject();
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectBuildpaths(rootEntry.getPath(), originatingProject);
        }
        boolean isRename = this.destination.segment(0).equals(originatingProject.getElementName());
        boolean updateOriginating = (this.updateModelFlags & 2) != 0;
        boolean bl = updateDestination = (this.updateModelFlags & 8) != 0;
        if (updateOriginating) {
            if (isRename && updateDestination) {
                this.renameEntryInBuildpath(rootEntry.getPath(), originatingProject);
            } else {
                this.removeEntryFromBuildpath(rootEntry.getPath(), originatingProject);
            }
        }
        if (!(!updateDestination || isRename && updateOriginating)) {
            this.addEntryToBuildpath(rootEntry, workspaceRoot);
        }
    }

    protected void moveResource(IProjectFragment root, IBuildpathEntry rootEntry, final IWorkspaceRoot workspaceRoot) throws ModelException {
        char[][] exclusionPatterns = ((BuildpathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (rootEntry.getEntryKind() != 3 || exclusionPatterns == null) {
            try {
                IResource destRes;
                if ((this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(this.destination)) != null) {
                    destRes.delete(this.updateResourceFlags, this.progressMonitor);
                }
                rootResource.move(this.destination, this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        final int sourceSegmentCount = rootEntry.getPath().segmentCount();
        final IFolder destFolder = workspaceRoot.getFolder(this.destination);
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource destRes;
                if (proxy.getType() == 2) {
                    IResource destRes2;
                    IPath path = proxy.requestFullPath();
                    if (MoveProjectFragmentOperation.this.prefixesOneOf(path, nestedFolders)) {
                        if (MoveProjectFragmentOperation.this.equalsOneOf(path, nestedFolders)) {
                            return false;
                        }
                        IFolder folder = destFolder.getFolder(path.removeFirstSegments(sourceSegmentCount));
                        if ((MoveProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && folder.exists()) {
                            return true;
                        }
                        folder.create(MoveProjectFragmentOperation.this.updateResourceFlags, true, MoveProjectFragmentOperation.this.progressMonitor);
                        return true;
                    }
                    IPath destPath = MoveProjectFragmentOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                    if ((MoveProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && (destRes2 = workspaceRoot.findMember(destPath)) != null) {
                        destRes2.delete(MoveProjectFragmentOperation.this.updateResourceFlags, MoveProjectFragmentOperation.this.progressMonitor);
                    }
                    proxy.requestResource().move(destPath, MoveProjectFragmentOperation.this.updateResourceFlags, MoveProjectFragmentOperation.this.progressMonitor);
                    return false;
                }
                IPath path = proxy.requestFullPath();
                IPath destPath = MoveProjectFragmentOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                if ((MoveProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(destPath)) != null) {
                    destRes.delete(MoveProjectFragmentOperation.this.updateResourceFlags, MoveProjectFragmentOperation.this.progressMonitor);
                }
                proxy.requestResource().move(destPath, MoveProjectFragmentOperation.this.updateResourceFlags, MoveProjectFragmentOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectBuildpaths(IPath rootPath, IScriptProject projectOfRoot) throws ModelException {
        IScriptModel model = this.getModel();
        IScriptProject[] projects = model.getScriptProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IScriptProject project = projects[i];
            if (!project.equals(projectOfRoot)) {
                this.renameEntryInBuildpath(rootPath, project);
            }
            ++i;
        }
    }

    protected void removeEntryFromBuildpath(IPath rootPath, IScriptProject project) throws ModelException {
        IBuildpathEntry[] buildpath = project.getRawBuildpath();
        IBuildpathEntry[] newBuildpath = null;
        int cpLength = buildpath.length;
        int newCPIndex = -1;
        int i = 0;
        while (i < cpLength) {
            IBuildpathEntry entry = buildpath[i];
            if (rootPath.equals((Object)entry.getPath())) {
                if (newBuildpath == null) {
                    newBuildpath = new IBuildpathEntry[cpLength];
                    System.arraycopy(buildpath, 0, newBuildpath, 0, i);
                    newCPIndex = i;
                }
            } else if (newBuildpath != null) {
                newBuildpath[newCPIndex++] = entry;
            }
            ++i;
        }
        if (newBuildpath != null) {
            if (newCPIndex < newBuildpath.length) {
                IBuildpathEntry[] iBuildpathEntryArray = newBuildpath;
                newBuildpath = new IBuildpathEntry[newCPIndex];
                System.arraycopy(iBuildpathEntryArray, 0, newBuildpath, 0, newCPIndex);
            }
            project.setRawBuildpath(newBuildpath, this.progressMonitor);
        }
    }
}

