/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.NopTypeNameRequestor;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.ruby.core.Messages;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.osgi.framework.BundleContext;

public class RubyPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.ruby.core";
    public static final boolean DUMP_EXCEPTIONS_TO_CONSOLE = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.ruby.core/dumpErrorsToConsole"));
    private static RubyPlugin plugin;
    private final ListenerList<IShutdownListener> shutdownListeners = new ListenerList();

    public RubyPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void addShutdownListener(IShutdownListener listener) {
        this.shutdownListeners.add((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        for (IShutdownListener listener : this.shutdownListeners) {
            listener.shutdown();
        }
        this.shutdownListeners.clear();
        plugin = null;
        this.savePluginPreferences();
        super.stop(context);
    }

    public static RubyPlugin getDefault() {
        return plugin;
    }

    public static void log(Exception ex) {
        String message;
        if (DLTKCore.DEBUG || DUMP_EXCEPTIONS_TO_CONSOLE) {
            ex.printStackTrace();
        }
        if ((message = ex.getMessage()) == null) {
            message = "(no message)";
        }
        RubyPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, (Throwable)ex));
    }

    public static void log(String message) {
        if (DLTKCore.DEBUG || DUMP_EXCEPTIONS_TO_CONSOLE) {
            System.out.println(message);
        }
        RubyPlugin.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, message, null));
    }

    public static void initializeAfterLoad(IProgressMonitor monitor) throws CoreException {
        try {
            if (monitor != null) {
                monitor.beginTask(Messages.RubyPlugin_initializingDltkRuby, 100);
            }
            SearchEngine engine = new SearchEngine();
            IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)RubyLanguageToolkit.getDefault());
            try {
                if (monitor != null) {
                    monitor.subTask(Messages.RubyPlugin_initializingSearchEngine);
                }
                engine.searchAllTypeNames(null, 0, "!@$#!@".toCharArray(), 10, 0, scope, (TypeNameRequestor)new NopTypeNameRequestor(), 2, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 49)));
            }
            catch (ModelException modelException) {
            }
            catch (OperationCanceledException e) {
                if (monitor != null && monitor.isCanceled()) {
                    throw e;
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }
}

