/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.builder.ISourceLineTracker;

class LineTracker {
    private final ISourceLineTracker lineTracker;

    public LineTracker(ISourceLineTracker lineTracker) {
        this.lineTracker = lineTracker;
    }

    public int getOffset(int line, int column) {
        return line > 0 ? this.lineTracker.getLineOffset(line - 1) + Math.max(column, 0) : 0;
    }

    public final int getLineNumberOfOffset(int offset) {
        return this.lineTracker.getLineNumberOfOffset(offset);
    }

    public final int getLength() {
        return this.lineTracker.getLength();
    }

    public final int getNumberOfLines() {
        return this.lineTracker.getNumberOfLines();
    }

    public int getOffset(Token token) {
        CommonToken commonToken;
        if (token.getLine() >= this.lineTracker.getNumberOfLines() && token instanceof CommonToken && (commonToken = (CommonToken)token).getStartIndex() <= this.lineTracker.getLength()) {
            return commonToken.getStartIndex();
        }
        return this.getOffset(token.getLine(), token.getCharPositionInLine());
    }

    public int length(Token token) {
        String sm = token.getText();
        return sm != null ? sm.length() : 1;
    }

    public ISourceRange toSourceRange(Token token) {
        return new SourceRange(this.getOffset(token), this.length(token));
    }
}

