/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.internal.ui.util.TableLayoutComposite;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.ui.AddValidatorDialog;
import org.eclipse.dltk.validators.internal.ui.IAddValidatorDialogRequestor;
import org.eclipse.dltk.validators.internal.ui.ValidatorMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ValidatorBlock
implements IAddValidatorDialogRequestor {
    private Composite fControl;
    protected List<IValidator> fValidators = new ArrayList<IValidator>();
    protected CheckboxTableViewer fValidatorList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fCopyButton;
    private int fSortColumn = 0;
    private Table fTable;
    private static String fgLastUsedID;

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Font font = ancestor.getFont();
        parent.setFont(font);
        parent.setLayout((Layout)layout);
        this.fControl = parent;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(ValidatorMessages.InstalledValidatorBlock_15);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        PixelConverter conv = new PixelConverter((Control)parent);
        data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        TableLayoutComposite tblComposite = new TableLayoutComposite(parent, 0);
        tblComposite.setLayoutData((Object)data);
        this.fTable = new Table((Composite)tblComposite, 67618);
        data = new GridData(1808);
        data.widthHint = 450;
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setText(ValidatorMessages.InstalledValidatorBlock_0);
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorBlock.this.sortByName();
            }
        });
        TableColumn column2 = new TableColumn(this.fTable, 0);
        column2.setText(ValidatorMessages.InstalledValidatorBlock_2);
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorBlock.this.sortByType();
            }
        });
        TableColumn column3 = new TableColumn(this.fTable, 0);
        column3.setText(ValidatorMessages.InstalledValidatorBlock_1);
        this.fValidatorList = new CheckboxTableViewer(this.fTable);
        this.fValidatorList.setLabelProvider((IBaseLabelProvider)new ValidatorLabelProvider());
        this.fValidatorList.setContentProvider((IContentProvider)new ValidatorContentProvider());
        this.fValidatorList.addCheckStateListener(event -> {
            IValidator validator = (IValidator)event.getElement();
            validator.setAutomatic(event.getChecked());
        });
        this.sortByName();
        this.fValidatorList.addSelectionChangedListener(evt -> this.enableButtons());
        this.fValidatorList.addDoubleClickListener(e -> {
            if (!this.fValidatorList.getSelection().isEmpty()) {
                this.editValidator();
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && ValidatorBlock.this.fRemoveButton.getEnabled()) {
                    ValidatorBlock.this.removeValidator();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fAddButton = this.createPushButton(buttons, ValidatorMessages.InstalledValidatorBlock_3);
        this.fAddButton.addListener(13, evt -> this.addValidator());
        this.fEditButton = this.createPushButton(buttons, ValidatorMessages.InstalledValidatorBlock_4);
        this.fEditButton.addListener(13, evt -> this.editValidator());
        this.fCopyButton = this.createPushButton(buttons, ValidatorMessages.InstalledValidatorBlock_16);
        this.fCopyButton.addListener(13, evt -> this.copyValidator());
        this.fRemoveButton = this.createPushButton(buttons, ValidatorMessages.InstalledValidatorBlock_5);
        this.fRemoveButton.addListener(13, evt -> this.removeValidator());
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fillWithWorkspaceValidators();
        this.enableButtons();
    }

    private void sortByType() {
        this.fValidatorList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IValidator && e2 instanceof IValidator) {
                    String rightType;
                    IValidator left = (IValidator)e1;
                    IValidator right = (IValidator)e2;
                    String leftType = left.getValidatorType().getName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getValidatorType().getName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fValidatorList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IValidator && e2 instanceof IValidator) {
                    IValidator left = (IValidator)e1;
                    IValidator right = (IValidator)e2;
                    String name = left.getName();
                    if (name == null) {
                        return 0;
                    }
                    return name.compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fValidatorList.getSelection();
        int selectionCount = selection.size();
        boolean addEnabled = ValidatorRuntime.getPossibleValidatorTypes().length > 0;
        boolean editEnabled = selectionCount == 1;
        boolean removeEnabled = true;
        boolean copyEnabled = false;
        if (selectionCount > 0) {
            for (IValidator install : selection) {
                if (!this.isContributed(install)) continue;
                removeEnabled = false;
                copyEnabled = false;
            }
        } else {
            removeEnabled = false;
        }
        this.fAddButton.setEnabled(addEnabled);
        this.fEditButton.setEnabled(editEnabled);
        this.fRemoveButton.setEnabled(removeEnabled);
        this.fCopyButton.setEnabled(copyEnabled);
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    private boolean isContributed(IValidator install) {
        return install.getValidatorType().isBuiltin();
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setValidators(IValidator[] validators) {
        this.fValidators.clear();
        ArrayList<IValidator> automatic = new ArrayList<IValidator>();
        int i = 0;
        while (i < validators.length) {
            if (validators[i].isAutomatic()) {
                automatic.add(validators[i]);
            }
            this.fValidators.add(validators[i]);
            ++i;
        }
        this.fValidatorList.setInput(this.fValidators);
        this.fValidatorList.setCheckedElements(automatic.toArray());
        this.fValidatorList.refresh();
    }

    public IValidator[] getValidators() {
        return this.fValidators.toArray(new IValidator[this.fValidators.size()]);
    }

    @Override
    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fValidators.size()) {
            IValidator validator = this.fValidators.get(i);
            String validatorName = validator.getName();
            if (validatorName == null) {
                return true;
            }
            if (validatorName.equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeValidator() {
        IStructuredSelection selection = (IStructuredSelection)this.fValidatorList.getSelection();
        IValidator[] validators = new IValidator[selection.size()];
        int i = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            validators[i++] = (IValidator)iter.next();
        }
        this.removeValidators(validators);
    }

    public void removeValidators(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            this.fValidators.remove(validators[i]);
            ++i;
        }
        this.fValidatorList.refresh();
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fValidatorList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException e) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.sortByType();
            }
        }
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width <= 0) {
                this.fTable.getColumn(i).pack();
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    protected void fillWithWorkspaceValidators() {
        ArrayList<IValidator> all = new ArrayList<IValidator>();
        IValidatorType[] types = ValidatorRuntime.getValidatorTypes();
        int i = 0;
        while (i < types.length) {
            IValidator[] validators;
            IValidatorType type = types[i];
            if ((!type.isBuiltin() || type.isConfigurable()) && (validators = type.getValidators()) != null) {
                int j = 0;
                while (j < validators.length) {
                    all.add(validators[j].getWorkingCopy());
                    ++j;
                }
            }
            ++i;
        }
        this.setValidators(all.toArray(new IValidator[all.size()]));
    }

    @Override
    public void validatorAdded(IValidator validator) {
        this.fValidators.add(validator);
        this.fValidatorList.add((Object)validator);
        this.fValidatorList.setChecked((Object)validator, validator.isAutomatic());
        this.fValidatorList.setSelection((ISelection)new StructuredSelection((Object)validator));
    }

    protected String createUniqueId(IValidatorType InterpreterType) {
        String id = null;
        while (InterpreterType.findValidator(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    protected String generateName(String name) {
        if (!this.isDuplicateName(name)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName);
        }
        return this.generateName(String.valueOf(name) + " (1)");
    }

    protected void copyValidator() {
    }

    protected void addValidator() {
        AddValidatorDialog dialog = new AddValidatorDialog(this, this.getShell(), ValidatorRuntime.getPossibleValidatorTypes(), null);
        dialog.setTitle(ValidatorMessages.InstalledValidatorBlock_7);
        if (dialog.open() != 0) {
            dialog.removeValidators(true);
            return;
        }
        dialog.removeValidators(false);
        this.fValidatorList.refresh();
    }

    protected void editValidator() {
        IStructuredSelection selection = (IStructuredSelection)this.fValidatorList.getSelection();
        IValidator validator = (IValidator)selection.getFirstElement();
        if (validator == null) {
            return;
        }
        AddValidatorDialog dialog = new AddValidatorDialog(this, this.getShell(), ValidatorRuntime.getValidatorTypes(), validator);
        dialog.setTitle(ValidatorMessages.InstalledValidatorBlock_8);
        if (dialog.open() != 0) {
            return;
        }
        this.fValidatorList.refresh((Object)validator);
    }

    private static class ValidatorContentProvider
    implements IStructuredContentProvider {
        private ValidatorContentProvider() {
        }

        public Object[] getElements(Object input) {
            return ((List)input).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ValidatorLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ValidatorLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IValidator) {
                IValidator validator = (IValidator)element;
                switch (columnIndex) {
                    case 0: {
                        return validator.getName();
                    }
                    case 1: {
                        return validator.getValidatorType().getName();
                    }
                    case 2: {
                        String nature = validator.getValidatorType().getNature();
                        if ("#".equals(nature)) {
                            return ValidatorMessages.ValidatorBlock_all;
                        }
                        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((String)nature);
                        if (languageToolkit != null) {
                            return languageToolkit.getLanguageName();
                        }
                        return ValidatorMessages.ValidatorBlock_unknown;
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

