/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.IProjectFragmentManipulationQuery;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ide.undo.ResourceDescription;

public class DeleteProjectFragmentChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;
    private final IProjectFragmentManipulationQuery fUpdateClasspathQuery;

    public DeleteProjectFragmentChange(IProjectFragment root, boolean isExecuteChange, IProjectFragmentManipulationQuery updateClasspathQuery) {
        Assert.isNotNull((Object)root);
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fHandle = root.getHandleIdentifier();
        this.fIsExecuteChange = isExecuteChange;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public String getName() {
        Object[] keys = new String[]{this.getRoot().getElementName()};
        return Messages.format(RefactoringCoreMessages.DeleteProjectFragmentChange_delete, keys);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    private IProjectFragment getRoot() {
        return (IProjectFragment)DLTKCore.create((String)this.fHandle);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 2);
        }
        return super.isValid(pm, 3);
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        if (!this.confirmDeleteIfReferenced()) {
            return new NullChange();
        }
        int resourceUpdateFlags = 2;
        int jCoreUpdateFlags = 6;
        pm.beginTask("", 2);
        IProjectFragment root = this.getRoot();
        IResource rootResource = root.getResource();
        CompositeChange result = new CompositeChange(this.getName());
        ResourceDescription rootDescription = ResourceDescription.fromResource((IResource)rootResource);
        IScriptProject[] referencingProjects = ModelElementUtil.getReferencingProjects(root);
        HashMap<IFile, String> classpathFilesContents = new HashMap<IFile, String>();
        int i = 0;
        while (i < referencingProjects.length) {
            IScriptProject javaProject = referencingProjects[i];
            IFile classpathFile = javaProject.getProject().getFile(".buildpath");
            if (classpathFile.exists()) {
                classpathFilesContents.put(classpathFile, DeleteProjectFragmentChange.getFileContents(classpathFile));
            }
            ++i;
        }
        root.delete(resourceUpdateFlags, jCoreUpdateFlags, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        rootDescription.recordStateFromHistory(rootResource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        for (Map.Entry entry : classpathFilesContents.entrySet()) {
            IFile file = (IFile)entry.getKey();
            String contents = (String)entry.getValue();
            TextFileChange classpathUndo = new TextFileChange(Messages.format(RefactoringCoreMessages.DeleteProjectFragmentChange_restore_file, file.getFullPath().toOSString()), file);
            classpathUndo.setEdit((TextEdit)new ReplaceEdit(0, DeleteProjectFragmentChange.getFileLength(file), contents));
            result.add((Change)classpathUndo);
        }
        result.add((Change)new UndoDeleteResourceChange(rootDescription));
        pm.done();
        return result;
    }

    private boolean confirmDeleteIfReferenced() throws ModelException {
        if (!this.getRoot().isArchive()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IScriptProject[] referencingProjects = ModelElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length == 0) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
    }

    private static int getFileLength(IFile file) throws CoreException {
        InputStreamReader reader;
        InputStream contents = file.getContents();
        try {
            reader = new InputStreamReader(contents, file.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            DLTKUIPlugin.log(e);
            reader = new InputStreamReader(contents);
        }
        try {
            return (int)reader.skip(Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, DLTKUIPlugin.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    private static String getFileContents(IFile file) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            String string = manager.getTextFileBuffer(path, LocationKind.IFILE).getDocument().get();
            return string;
        }
        finally {
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

