/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesDocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public class BitFlagsQuery
extends Query {
    private final int fTrueFlags;
    private final int fFalseFlags;

    public BitFlagsQuery(int trueFlags, int falseFlags) {
        this.fTrueFlags = trueFlags;
        this.fFalseFlags = falseFlags;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.fFalseFlags;
        result = 31 * result + this.fTrueFlags;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BitFlagsQuery other = (BitFlagsQuery)((Object)obj);
        if (this.fFalseFlags != other.fFalseFlags) {
            return false;
        }
        return this.fTrueFlags == other.fTrueFlags;
    }

    public String toString(String input) {
        return MessageFormat.format("BitFlagsQuery(Field: {0}, True Flags: {1}, False Flags: {2})", "flagsNDV", this.fTrueFlags, this.fFalseFlags);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
            }

            public void normalize(float norm, float topLevelBoost) {
            }

            public float getValueForNormalization() throws IOException {
                return 0.0f;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                boolean match;
                Scorer scorer = this.scorer(context, context.reader().getLiveDocs());
                boolean bl = match = scorer != null && scorer.advance(doc) == doc;
                if (match) {
                    if (!$assertionsDisabled && scorer.score() != 0.0f) {
                        throw new AssertionError();
                    }
                    return Explanation.match((float)0.0f, (String)("Match on id" + doc), (Explanation[])new Explanation[0]);
                }
                return Explanation.match((float)0.0f, (String)("No match on id" + doc), (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                DocIdSet set = BitFlagsQuery.this.getDocIdSet(context, acceptDocs);
                if (set == null) {
                    return null;
                }
                DocIdSetIterator iterator = set.iterator();
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, 0.0f, iterator);
            }
        };
    }

    protected DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        final NumericDocValues numDocValues = DocValues.getNumeric((LeafReader)context.reader(), (String)"flagsNDV");
        return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

            protected boolean matchDoc(int doc) {
                long flags = numDocValues.get(doc);
                if (BitFlagsQuery.this.fTrueFlags != 0 && (flags & (long)BitFlagsQuery.this.fTrueFlags) == 0L) {
                    return false;
                }
                return BitFlagsQuery.this.fFalseFlags == 0 || (flags & (long)BitFlagsQuery.this.fFalseFlags) == 0L;
            }
        };
    }
}

