/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.DLTKUI;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.InitializeJob;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.IScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.WorkingCopyManager;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.internal.ui.viewsupport.ContextActivator;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathAttributeConfigurationDescriptors;
import org.eclipse.dltk.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.Messages;
import org.eclipse.dltk.ui.editor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.dltk.ui.text.completion.ContentAssistHistory;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.dltk.ui.viewsupport.ImagesOnFileSystemRegistry;
import org.eclipse.dltk.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.dltk.utils.ExecutionContexts;
import org.eclipse.dltk.utils.IExecutableOperation;
import org.eclipse.dltk.utils.IExecutionContextManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class DLTKUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.ui";
    public static final String ID_SCRIPT_EXPLORER = "org.eclipse.dltk.ui.ScriptExplorer";
    @Deprecated
    public static final String ID_SCRIPTEXPLORER = "org.eclipse.dltk.ui.ScriptExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.dltk.ui.TypeHierarchy";
    public static final String ID_BUILDPATH_VARIABLES_PREFERENCE_PAGE = "org.eclipse.dltk.ui.preferences.BuildpathVariablesPreferencePage";
    public static final String CONTEXT_VIEWS = "org.eclipse.dltk.ui.context.views";
    private static DLTKUIPlugin plugin;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private ContentAssistHistory fContentAssistHistory;
    private BuildpathAttributeConfigurationDescriptors fBuildpathAttributeConfigurationDescriptors;
    private final ListenerList shutdownListeners = new ListenerList();
    private IWorkingCopyManager fWorkingCopyManager;
    private ISourceModuleDocumentProvider fSourceModuleDocumentProvider;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private final Map<String, EditorTextHoverDescriptor[]> editorTextHoverDescriptorsByNature = new HashMap<String, EditorTextHoverDescriptor[]>();
    private SaveParticipantRegistry fSaveParticipantRegistry;
    private ImagesOnFileSystemRegistry fImagesOnFSRegistry;

    public DLTKUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null) {
                    if (resource instanceof IFile) {
                        return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                    }
                } else if (original instanceof IExternalSourceModule) {
                    IProjectFragment fragment = (IProjectFragment)original.getAncestor(3);
                    if (!fragment.isArchive()) {
                        return BufferManager.createBuffer((IOpenable)original);
                    }
                    return BufferManager.createBuffer((IOpenable)original);
                }
                if (original instanceof DBGPSourceModule) {
                    return BufferManager.createBuffer((IOpenable)original);
                }
                if (original instanceof BuiltinSourceModule) {
                    return BufferManager.createBuffer((IOpenable)original);
                }
                return DocumentAdapter.NULL;
            }
        });
        IPreferenceStore store = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(store);
        DLTKLaunchingPlugin.getDefault();
        try {
            PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new ShutdownCloseRemoteEditorsListener());
            ContextActivator.getInstance().install();
        }
        catch (IllegalStateException illegalStateException) {}
        ExecutionContexts.setManager((IExecutionContextManager)new UIExecutionContextManager());
        new InitializeJob().schedule();
    }

    public void addShutdownListener(IShutdownListener listener) {
        this.shutdownListeners.add((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        ExecutionContexts.setManager(null);
        if (this.fMembersOrderPreferenceCache != null) {
            this.fMembersOrderPreferenceCache.dispose();
            this.fMembersOrderPreferenceCache = null;
        }
        Object[] listeners = this.shutdownListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShutdownListener)listeners[i]).shutdown();
            ++i;
        }
        this.shutdownListeners.clear();
        super.stop(context);
        plugin = null;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbench workbench;
        try {
            workbench = this.getWorkbench();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public static DLTKUIPlugin getDefault() {
        return plugin;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static IWorkbenchPage getActivePage() {
        return DLTKUIPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DLTKUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ISourceModuleDocumentProvider provider = this.getSourceModuleDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ISourceModuleDocumentProvider getSourceModuleDocumentProvider() {
        if (this.fSourceModuleDocumentProvider == null) {
            this.fSourceModuleDocumentProvider = new SourceModuleDocumentProvider();
        }
        return this.fSourceModuleDocumentProvider;
    }

    public static ISourceModuleDocumentProvider getDocumentProvider() {
        return DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DLTKUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static ISourceModule getEditorInputModelElement(IEditorInput editorInput) {
        ISourceModule module;
        ISourceModule je = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, false);
        if (je != null) {
            return je;
        }
        if (editorInput instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)editorInput)) != null) {
            return module;
        }
        IModelElement me = (IModelElement)editorInput.getAdapter(IModelElement.class);
        if (me instanceof ISourceModule) {
            return (ISourceModule)me;
        }
        return null;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        DLTKUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, DLTKUIMessages.ScriptPlugin_internal_error, e));
    }

    public static void logErrorMessage(String message) {
        DLTKUIPlugin.logErrorMessage(message, null);
    }

    public static void warn(String message) {
        DLTKUIPlugin.warn(message, null);
    }

    public static void warn(String message, Throwable throwable) {
        DLTKUIPlugin.log((IStatus)new Status(2, PLUGIN_ID, 10001, message, throwable));
    }

    public static void logErrorMessage(String message, Throwable throwable) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, throwable));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            DLTKUIPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        DLTKUIPlugin.log((IStatus)multi);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DLTKUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public ContentAssistHistory getContentAssistHistory() {
        if (this.fContentAssistHistory == null) {
            try {
                this.fContentAssistHistory = ContentAssistHistory.load(this.getPluginPreferences(), "content_assist_lru_history");
            }
            catch (CoreException x) {
                DLTKUIPlugin.log(x);
            }
            if (this.fContentAssistHistory == null) {
                this.fContentAssistHistory = new ContentAssistHistory();
            }
        }
        return this.fContentAssistHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void resetEditorTextHoverDescriptors() {
        Map<String, EditorTextHoverDescriptor[]> map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            this.editorTextHoverDescriptorsByNature.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditorTextHoverDescriptors(String natureId) {
        Map<String, EditorTextHoverDescriptor[]> map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            this.editorTextHoverDescriptorsByNature.remove(natureId);
        }
    }

    @Deprecated
    public EditorTextHoverDescriptor[] getEditorTextHoverDescriptors(IPreferenceStore store) {
        return this.initializeEditorTextHoverDescriprtors(store, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorTextHoverDescriptor[] getEditorTextHoverDescriptors(IPreferenceStore store, String natureId) {
        EditorTextHoverDescriptor[] descriptors;
        Map<String, EditorTextHoverDescriptor[]> map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            descriptors = this.editorTextHoverDescriptorsByNature.get(natureId);
        }
        if (descriptors == null && (descriptors = this.initializeEditorTextHoverDescriprtors(store, natureId)) != null && natureId != null) {
            map = this.editorTextHoverDescriptorsByNature;
            synchronized (map) {
                this.editorTextHoverDescriptorsByNature.put(natureId, descriptors);
            }
        }
        return descriptors;
    }

    private EditorTextHoverDescriptor[] initializeEditorTextHoverDescriprtors(IPreferenceStore store, String natureId) {
        Object[] descriptors = EditorTextHoverDescriptor.getContributedHovers(natureId, store);
        ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

            public IConfigurationElement getConfigurationElement(Object object) {
                return ((EditorTextHoverDescriptor)object).getConfigurationElement();
            }
        };
        sorter.sort(descriptors);
        int i = 0;
        while (i < descriptors.length - 1) {
            if ("org.eclipse.dltk.ui.BestMatchHover".equals(((EditorTextHoverDescriptor)descriptors[i]).getId())) {
                Object hoverDescriptor = descriptors[i];
                int j = i;
                while (j > 0) {
                    descriptors[j] = descriptors[j - 1];
                    --j;
                }
                descriptors[0] = hoverDescriptor;
                break;
            }
            ++i;
        }
        return descriptors;
    }

    public static IEditorPart openInEditor(IModelElement element) throws ModelException, PartInitException {
        return DLTKUIPlugin.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(IModelElement element, boolean activate, boolean reveal) throws ModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public static boolean isDebug() {
        return DLTKCore.DEBUG;
    }

    public BuildpathAttributeConfigurationDescriptors getClasspathAttributeConfigurationDescriptors() {
        if (this.fBuildpathAttributeConfigurationDescriptors == null) {
            this.fBuildpathAttributeConfigurationDescriptors = new BuildpathAttributeConfigurationDescriptors();
        }
        return this.fBuildpathAttributeConfigurationDescriptors;
    }

    public static ISourceModule resolveSourceModule(FileStoreEditorInput input) {
        final ISourceModule[] modules = new ISourceModule[1];
        final IPath filePath = URIUtil.toPath((URI)input.getURI());
        IScriptModel scriptModel = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            scriptModel.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    boolean shouldDescend;
                    boolean bl = shouldDescend = modules[0] == null;
                    if (shouldDescend) {
                        if (element instanceof ExternalProjectFragment) {
                            ExternalProjectFragment fragment = (ExternalProjectFragment)element;
                            try {
                                if (filePath.removeLastSegments(1).toFile().getCanonicalPath().startsWith(fragment.getPath().toFile().getCanonicalPath())) {
                                    ISourceModule module;
                                    Path folderPath = new Path(filePath.removeLastSegments(1).toFile().getCanonicalPath());
                                    IScriptFolder folder = fragment.getScriptFolder((IPath)(folderPath = folderPath.removeFirstSegments(new Path(fragment.getPath().toFile().getCanonicalPath()).segmentCount())));
                                    if (folder != null && folder.exists() && (module = folder.getSourceModule(filePath.lastSegment())) != null) {
                                        modules[0] = module;
                                    }
                                }
                            }
                            catch (IOException ixcn) {
                                ixcn.printStackTrace();
                            }
                            shouldDescend = false;
                        } else {
                            shouldDescend = element instanceof IScriptProject || element instanceof IScriptModel;
                        }
                    }
                    return shouldDescend;
                }
            });
        }
        catch (ModelException mxcn) {
            mxcn.printStackTrace();
        }
        return modules[0];
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static String getAdditionalInfoAffordanceString() {
        if (!EditorsUI.getPreferenceStore().getBoolean("showTextHoverAffordance")) {
            return null;
        }
        return Messages.DLTKUIPlugin_additionalInfo_affordance;
    }

    public synchronized SaveParticipantRegistry getSaveParticipantRegistry() {
        if (this.fSaveParticipantRegistry == null) {
            this.fSaveParticipantRegistry = new SaveParticipantRegistry();
        }
        return this.fSaveParticipantRegistry;
    }

    public ImagesOnFileSystemRegistry getImagesOnFSRegistry() {
        if (this.fImagesOnFSRegistry == null) {
            this.fImagesOnFSRegistry = new ImagesOnFileSystemRegistry();
        }
        return this.fImagesOnFSRegistry;
    }

    static class ShutdownCloseRemoteEditorsListener
    implements IWorkbenchListener {
        ShutdownCloseRemoteEditorsListener() {
        }

        public void postShutdown(IWorkbench workbench) {
        }

        public boolean preShutdown(final IWorkbench workbench, boolean forced) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    this.preShutdownInternal(workbench);
                }

                public void handleException(Throwable exception) {
                }
            });
            return true;
        }

        void preShutdownInternal(IWorkbench workbench) {
            IWorkbenchPage page;
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart editor = references[i].getEditor(false);
                    if (editor != null && editor instanceof IScriptEditor) {
                        this.closeEditor(page, editor);
                    }
                    ++i;
                }
            }
        }

        private void closeEditor(IWorkbenchPage page, IEditorPart editor) {
            IEnvironment environment;
            ISourceModule modelElement = EditorUtility.getEditorInputModelElement(editor, false);
            if (modelElement != null && (environment = EnvironmentManager.getEnvironment((IModelElement)modelElement)) != null && !environment.isLocal()) {
                page.closeEditor(editor, false);
            }
        }
    }

    private static class UIExecutionContextManager
    implements IExecutionContextManager {
        private boolean active = false;

        private UIExecutionContextManager() {
        }

        public void executeInBackground(final IExecutableOperation operation) {
            if (!this.isRunningInUIThread()) {
                operation.execute((IProgressMonitor)new NullProgressMonitor());
            } else if (DLTKUI.isStarted()) {
                if (this.active) {
                    return;
                }
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(null){

                    protected void configureShell(Shell shell) {
                        super.configureShell(shell);
                        shell.setText(operation.getOperationName());
                    }
                };
                this.active = true;
                try {
                    try {
                        dialog.run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                if (!this.isRunningInUIThread()) {
                                    operation.execute(monitor);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        DLTKCore.error((String)e.getMessage(), (Throwable)e);
                        this.active = false;
                    }
                    catch (InterruptedException e) {
                        DLTKCore.error((String)e.getMessage(), (Throwable)e);
                        this.active = false;
                    }
                }
                finally {
                    this.active = false;
                }
            }
        }

        public boolean isRunningInUIThread() {
            return Display.getCurrent() != null;
        }
    }
}

