/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterNodeRewriter;
import org.eclipse.dltk.formatter.FormatterTextNode;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterCommentableNode;
import org.eclipse.dltk.formatter.IFormatterContainerNode;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.ruby.formatter.internal.nodes.FormatterCommentNode;
import org.jruby.ast.CommentNode;
import org.jruby.parser.RubyParserResult;

public class RubyFormatterNodeRewriter
extends FormatterNodeRewriter {
    public RubyFormatterNodeRewriter(RubyParserResult result) {
        for (CommentNode commentNode : result.getCommentNodes()) {
            if (commentNode.isBlock()) continue;
            this.addComment(commentNode.getStartOffset(), commentNode.getEndOffset(), commentNode);
        }
    }

    public void rewrite(IFormatterContainerNode root) {
        this.mergeTextNodes(root);
        this.insertComments(root);
        this.attachComments(root);
    }

    private void attachComments(IFormatterContainerNode root) {
        ArrayList commentNodes = new ArrayList();
        ArrayList<FormatterTextNode> comments = new ArrayList<FormatterTextNode>();
        List body = root.getBody();
        for (IFormatterNode node : body) {
            if (node instanceof FormatterCommentNode) {
                comments.add((FormatterCommentNode)node);
                continue;
            }
            if (FormatterUtils.isNewLine((IFormatterNode)node) && !comments.isEmpty() && comments.get(comments.size() - 1) instanceof FormatterCommentNode) {
                comments.add((FormatterTextNode)node);
                continue;
            }
            if (comments.isEmpty()) continue;
            if (node instanceof IFormatterCommentableNode) {
                ((IFormatterCommentableNode)node).insertBefore(comments);
                commentNodes.addAll(comments);
            }
            comments.clear();
        }
        body.removeAll(commentNodes);
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.attachComments((IFormatterContainerNode)node);
        }
    }

    protected IFormatterNode createCommentNode(IFormatterDocument document, int startOffset, int endOffset, Object object) {
        return new FormatterCommentNode(document, startOffset, endOffset);
    }
}

