/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;

public class ProgressMonitoringJob
extends Job
implements IProgressMonitor {
    private static final int BEGIN_TASK = 0;
    private static final int DONE = 1;
    private static final int INTERNAL_WORKED = 2;
    private static final int SET_CANCELED = 3;
    private static final int SET_TASK_NAME = 4;
    private static final int SUB_TASK = 5;
    private static final int WORKED = 6;
    private List<WorkNode> queue = new LinkedList<WorkNode>();
    private final Object lock = new Object();
    private boolean canceled = false;

    public ProgressMonitoringJob(String message, int totalWork) {
        super(message);
        this.setPriority(30);
        this.schedule();
        this.beginTask(message, totalWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        while (true) {
            Object object;
            if (monitor.isCanceled()) {
                object = this.lock;
                synchronized (object) {
                    this.canceled = true;
                    return Status.CANCEL_STATUS;
                }
            }
            object = this.lock;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    try {
                        this.lock.wait(100L);
                    }
                    catch (InterruptedException e) {
                        DLTKCore.error(e);
                    }
                    continue;
                }
                WorkNode node = this.queue.remove(0);
                if (node != null) {
                    switch (node.type) {
                        case 0: {
                            monitor.beginTask(node.message, (int)node.worked);
                            break;
                        }
                        case 1: {
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                        case 2: {
                            monitor.internalWorked(node.worked);
                            break;
                        }
                        case 3: {
                            monitor.setCanceled(node.worked == 1.0);
                            break;
                        }
                        case 4: {
                            monitor.setTaskName(node.message);
                            break;
                        }
                        case 5: {
                            monitor.subTask(node.message);
                            break;
                        }
                        case 6: {
                            monitor.worked((int)node.worked);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTask(String name, int totalWork) {
        Object object = this.lock;
        synchronized (object) {
            WorkNode node = new WorkNode(0, name, totalWork);
            this.addToQueue(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(WorkNode node) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(node);
            this.lock.notifyAll();
        }
    }

    public void done() {
        this.addToQueue(new WorkNode(1, null, 0.0));
    }

    public void internalWorked(double work) {
        this.addToQueue(new WorkNode(2, null, work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.lock;
        synchronized (object) {
            return this.canceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            this.canceled = value;
        }
        this.addToQueue(new WorkNode(3, null, value ? 1 : 0));
    }

    public void setTaskName(String name) {
        this.addToQueue(new WorkNode(4, name, 0.0));
    }

    public void subTask(String name) {
        this.addToQueue(new WorkNode(5, name, 0.0));
    }

    public void worked(int work) {
        this.addToQueue(new WorkNode(6, null, work));
    }

    private static class WorkNode {
        int type;
        String message;
        double worked;

        public WorkNode(int type, String message, double worked) {
            this.type = type;
            this.message = message;
            this.worked = worked;
        }
    }
}

