/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.core.IDLTKContributedExtension;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IPreferencesSaveDelegate;
import org.eclipse.dltk.internal.ui.util.SWTUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.PropertyLinkArea;
import org.eclipse.dltk.ui.formatter.AlreadyExistsDialog;
import org.eclipse.dltk.ui.formatter.CreateProfileDialog;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.IProfileStore;
import org.eclipse.dltk.ui.formatter.IProfileVersioner;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ProfileKind;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractFormatterSelectionBlock
extends AbstractOptionsBlock {
    private Composite fComposite;
    private Combo fProfileCombo;
    private Combo fFactoryCombo;
    private Label fFactoryDescription;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fNewButton;
    private Button fLoadButton;
    private int selectedFactory;
    private IScriptFormatterFactory[] factories;
    private Map<IScriptFormatterFactory, IProfileManager> profileByFactory = new HashMap<IScriptFormatterFactory, IProfileManager>();
    protected SourceViewer fPreviewViewer;
    private static List<IScriptFormatterFactory> TEMP_LIST = new ArrayList<IScriptFormatterFactory>();

    protected abstract IFormatterModifyDialogOwner createDialogOwner();

    protected abstract DLTKContributionExtensionManager getExtensionManager();

    protected abstract String getPreferenceLinkMessage();

    protected abstract PreferenceKey getSavedContributionKey();

    protected abstract void updatePreview();

    protected abstract SourceViewer createPreview(Composite var1);

    public AbstractFormatterSelectionBlock(IStatusChangeListener context, IProject project, PreferenceKey formatterKey, String natureId, IWorkbenchPreferenceContainer container) {
        super(context, project, AbstractFormatterSelectionBlock.collectPreferenceKeys(TEMP_LIST, natureId, formatterKey), container);
        this.factories = TEMP_LIST.toArray(new IScriptFormatterFactory[TEMP_LIST.size()]);
        TEMP_LIST = new ArrayList<IScriptFormatterFactory>();
    }

    protected IProfileManager getProfileManager() {
        return this.getProfileManager(this.getSelectedExtension());
    }

    protected IProfileManager getProfileManager(IScriptFormatterFactory factory) {
        IProfileManager manager = this.profileByFactory.get(factory);
        if (manager == null) {
            ArrayList<IProfile> allProfiles = new ArrayList<IProfile>();
            List<IProfile> buitinProfiles = factory.getBuiltInProfiles();
            if (buitinProfiles != null && buitinProfiles.size() > 0) {
                allProfiles.addAll(buitinProfiles);
            } else {
                DLTKUIPlugin.logErrorMessage(NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_noBuiltInProfiles, (Object)factory.getId()));
            }
            allProfiles.addAll(factory.getCustomProfiles());
            manager = factory.createProfileManager(allProfiles);
            this.selectCurrentProfile(factory, manager);
            this.profileByFactory.put(factory, manager);
        }
        return manager;
    }

    private void selectCurrentProfile(IScriptFormatterFactory factory, IProfileManager manager) {
        IProfile profile2;
        String profileId;
        PreferenceKey activeProfileKey = factory.getActiveProfileKey();
        if (activeProfileKey != null && (profileId = this.getValue(activeProfileKey)) != null && profileId.length() != 0 && (profile2 = manager.findProfile(profileId)) != null) {
            manager.setSelected(profile2);
            return;
        }
        Map<String, String> preferences = factory.retrievePreferences(new LoadDelegate());
        if (!preferences.isEmpty()) {
            for (IProfile profile2 : manager.getSortedProfiles()) {
                if (!profile2.equalsTo(preferences)) continue;
                manager.setSelected(profile2);
                return;
            }
        }
        String name = this.getProfileName(manager.getSortedProfiles(), FormatterMessages.AbstractFormatterSelectionBlock_activeProfileName);
        IProfile profile3 = manager.create(ProfileKind.CUSTOM, name, preferences, factory.getId(), factory.getProfileVersioner().getCurrentVersion());
        manager.setSelected(profile3);
    }

    protected String getProfileName(List<IProfile> profiles, String prefix) {
        HashSet<String> names = new HashSet<String>(profiles.size());
        for (IProfile profile : profiles) {
            names.add(profile.getName());
        }
        if (!names.contains(prefix)) {
            return prefix;
        }
        int i = 2;
        String name;
        while (names.contains(name = String.valueOf(prefix) + " " + i)) {
            ++i;
        }
        return name;
    }

    protected IProfile findProfile(Map<String, String> preferences, List<IProfile> profiles) {
        for (IProfile profile : profiles) {
            if (!profile.equalsTo(preferences)) continue;
            return profile;
        }
        return null;
    }

    @Override
    protected boolean saveValues() {
        for (Map.Entry<IScriptFormatterFactory, IProfileManager> entry : this.profileByFactory.entrySet()) {
            IProfileManager manager = entry.getValue();
            if (!manager.isDirty()) continue;
            entry.getKey().saveCustomProfiles(manager.getSortedProfiles());
            manager.clearDirty();
        }
        return super.saveValues();
    }

    protected void applyPreferences() {
        PreferenceKey activeProfileKey;
        IScriptFormatterFactory factory = this.getSelectedExtension();
        IProfileManager manager = this.getProfileManager(factory);
        IProfile profile = manager.getSelected();
        HashMap<String, String> settings = new HashMap<String, String>();
        if (profile != null) {
            settings.putAll(profile.getSettings());
        }
        if ((activeProfileKey = factory.getActiveProfileKey()) != null) {
            if (profile != null) {
                settings.put(activeProfileKey.getName(), profile.getID());
            } else {
                settings.remove(activeProfileKey.getName());
            }
        }
        SaveDelegate delegate = new SaveDelegate();
        factory.savePreferences(settings, delegate);
        this.updatePreview();
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        IProfileManager profileManager = this.getProfileManager();
        profileManager.setSelected(profileManager.getSortedProfiles().get(0));
        this.updateComboFromProfiles();
        this.updateSelection();
    }

    protected static PreferenceKey[] collectPreferenceKeys(List factories, String natureId, PreferenceKey formatterKey) {
        ArrayList<PreferenceKey> result = new ArrayList<PreferenceKey>();
        result.add(formatterKey);
        IDLTKContributedExtension[] extensions = ScriptFormatterManager.getInstance().getContributions(natureId);
        int i = 0;
        while (i < extensions.length) {
            PreferenceKey profile;
            IScriptFormatterFactory factory = (IScriptFormatterFactory)extensions[i];
            factories.add(factory);
            PreferenceKey[] keys = factory.getPreferenceKeys();
            if (keys != null) {
                Collections.addAll(result, keys);
            }
            if ((profile = factory.getActiveProfileKey()) != null) {
                result.add(profile);
            }
            ++i;
        }
        return result.toArray(new PreferenceKey[result.size()]);
    }

    @Override
    public final Control createOptionsBlock(Composite parent) {
        this.initializeProjectSettings();
        return this.createSelectorBlock(parent);
    }

    protected Composite createDescription(Composite parent, IDLTKContributedExtension contrib) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 4);
        String desc = contrib.getDescription();
        if (desc == null) {
            desc = "";
        }
        SWTFactory.createLabel(composite, desc, 1);
        String prefPageId = contrib.getPreferencePageId();
        String propPageId = contrib.getPropertyPageId();
        if (this.isProjectPreferencePage() && this.hasValidId(propPageId)) {
            new PropertyLinkArea(composite, 0, propPageId, (IAdaptable)this.fProject, this.getPreferenceLinkMessage(), this.getPreferenceContainer());
        }
        if (!this.isProjectPreferencePage() && this.hasValidId(prefPageId)) {
            new PreferenceLinkArea(composite, 0, prefPageId, this.getPreferenceLinkMessage(), this.getPreferenceContainer(), null);
        }
        return composite;
    }

    protected Composite createSelectorBlock(Composite parent) {
        PixelConverter fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        this.createFormatterSection(this.fComposite, 5, fPixConv);
        final Group group = SWTFactory.createGroup(this.fComposite, FormatterMessages.AbstractFormatterSelectionBlock_profilesGroup, 5, 5, 1808);
        Label profileLabel = new Label((Composite)group, 0);
        profileLabel.setText(FormatterMessages.AbstractFormatterSelectionBlock_activeProfile);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 5;
        profileLabel.setLayoutData((Object)data);
        this.fProfileCombo = AbstractFormatterSelectionBlock.createProfileCombo((Composite)group, 3, fPixConv.convertWidthInCharsToPixels(20));
        this.updateComboFromProfiles();
        this.fProfileCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.updateSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.updateSelection();
            }
        });
        this.fEditButton = AbstractFormatterSelectionBlock.createButton((Composite)group, FormatterMessages.AbstractFormatterSelectionBlock_editProfile, 32);
        this.fEditButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.editButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractFormatterSelectionBlock.this.editButtonPressed();
            }
        });
        this.fDeleteButton = AbstractFormatterSelectionBlock.createButton((Composite)group, FormatterMessages.AbstractFormatterSelectionBlock_removeProfile, 32);
        this.fDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.doDelete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.doDelete();
            }

            protected void doDelete() {
                IProfileManager profileManager = AbstractFormatterSelectionBlock.this.getProfileManager();
                IProfile selected = profileManager.getSelected();
                if (MessageDialog.openQuestion((Shell)group.getShell(), (String)FormatterMessages.AbstractFormatterSelectionBlock_confirmRemoveLabel, (String)NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_confirmRemoveMessage, (Object)selected.getName()))) {
                    profileManager.deleteProfile(selected);
                    AbstractFormatterSelectionBlock.this.updateComboFromProfiles();
                    AbstractFormatterSelectionBlock.this.applyPreferences();
                }
            }
        });
        this.fNewButton = AbstractFormatterSelectionBlock.createButton((Composite)group, FormatterMessages.AbstractFormatterSelectionBlock_newProfile, 32);
        this.fNewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.createNewProfile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.createNewProfile();
            }

            protected void createNewProfile() {
                IScriptFormatterFactory formatterFactory = AbstractFormatterSelectionBlock.this.getSelectedExtension();
                CreateProfileDialog p = new CreateProfileDialog(group.getShell(), AbstractFormatterSelectionBlock.this.getProfileManager(), formatterFactory.getProfileVersioner());
                if (p.open() != 0) {
                    return;
                }
                AbstractFormatterSelectionBlock.this.applyPreferences();
                AbstractFormatterSelectionBlock.this.updateComboFromProfiles();
                if (!p.openEditDialog()) {
                    return;
                }
                AbstractFormatterSelectionBlock.this.editButtonPressed();
            }
        });
        this.fLoadButton = AbstractFormatterSelectionBlock.createButton((Composite)group, FormatterMessages.AbstractFormatterSelectionBlock_importProfile, 128);
        this.fLoadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.doImport();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.doImport();
            }

            protected void doImport() {
                AlreadyExistsDialog aeDialog;
                IProfileManager profileManager;
                FileDialog dialog = new FileDialog(group.getShell(), 4096);
                dialog.setText(FormatterMessages.AbstractFormatterSelectionBlock_importProfileLabel);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                File file = new File(path);
                IScriptFormatterFactory factory = AbstractFormatterSelectionBlock.this.getSelectedExtension();
                Collection<IProfile> profiles = null;
                IProfileStore store = factory.getProfileStore();
                try {
                    profiles = store.readProfilesFromFile(file);
                }
                catch (CoreException e) {
                    DLTKUIPlugin.logErrorMessage(FormatterMessages.AbstractFormatterSelectionBlock_notValidProfile, e);
                }
                if (profiles == null || profiles.isEmpty()) {
                    return;
                }
                IProfile profile = profiles.iterator().next();
                IProfileVersioner versioner = factory.getProfileVersioner();
                if (!versioner.getFormatterId().equals(profile.getFormatterId())) {
                    String title = FormatterMessages.AbstractFormatterSelectionBlock_importProfileLabel;
                    String message = NLS.bind((String)FormatterMessages.AbstractFormatterSelectionBlock_notValidFormatter, (Object)versioner.getFormatterId(), (Object)profile.getFormatterId());
                    MessageDialog.openError((Shell)group.getShell(), (String)title, (String)message);
                    return;
                }
                if (profile.getVersion() > versioner.getCurrentVersion()) {
                    String title = FormatterMessages.AbstractFormatterSelectionBlock_importingProfile;
                    String message = FormatterMessages.AbstractFormatterSelectionBlock_moreRecentVersion;
                    MessageDialog.openWarning((Shell)group.getShell(), (String)title, (String)message);
                }
                if ((profileManager = AbstractFormatterSelectionBlock.this.getProfileManager()).containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(group.getShell(), profile, profileManager)).open() != 0) {
                    return;
                }
                ((IProfile.ICustomProfile)profile).setVersion(versioner.getCurrentVersion());
                profileManager.addProfile(profile);
                AbstractFormatterSelectionBlock.this.updateComboFromProfiles();
                AbstractFormatterSelectionBlock.this.applyPreferences();
            }
        });
        AbstractFormatterSelectionBlock.createLabel((Composite)group, "", 3);
        this.configurePreview((Composite)group, 5);
        this.updateButtons();
        this.applyPreferences();
        return this.fComposite;
    }

    protected void createFormatterSection(Composite composite, int numColumns, PixelConverter fPixConv) {
        String id = this.getValue(this.getSavedContributionKey());
        int index = -1;
        int i = 0;
        while (i < this.factories.length) {
            IScriptFormatterFactory factory = this.factories[i];
            if (factory.getId().equals(id)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1 && this.factories.length != 0) {
            index = 0;
            i = 1;
            while (i < this.factories.length) {
                if (this.factories[i].getPriority() > this.factories[index].getPriority()) {
                    index = i;
                }
                ++i;
            }
        }
        if (this.factories.length > 1) {
            AbstractFormatterSelectionBlock.createLabel(composite, FormatterMessages.AbstractFormatterSelectionBlock_formatterLabel, numColumns);
            this.fFactoryCombo = AbstractFormatterSelectionBlock.createProfileCombo(composite, numColumns, fPixConv.convertWidthInCharsToPixels(20));
            i = 0;
            while (i < this.factories.length) {
                this.fFactoryCombo.add(this.factories[i].getName());
                ++i;
            }
            this.fFactoryCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractFormatterSelectionBlock.this.doSetFactory(AbstractFormatterSelectionBlock.this.fFactoryCombo.getSelectionIndex());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AbstractFormatterSelectionBlock.this.doSetFactory(AbstractFormatterSelectionBlock.this.fFactoryCombo.getSelectionIndex());
                }
            });
            this.fFactoryCombo.select(index);
        }
        this.fFactoryDescription = AbstractFormatterSelectionBlock.createLabel(composite, "", numColumns, true);
        this.doSetFactory(index);
    }

    protected void doSetFactory(int index) {
        this.selectedFactory = index;
        this.setValue(this.getSavedContributionKey(), this.factories[index].getId());
        String desc = this.getSelectedExtension().getDescription();
        if (desc != null && desc.length() != 0) {
            this.fFactoryDescription.setText(desc);
        } else {
            this.fFactoryDescription.setVisible(false);
            GridData data = (GridData)this.fFactoryDescription.getLayoutData();
            data.exclude = true;
        }
        this.updateComboFromProfiles();
        this.applyPreferences();
    }

    protected void configurePreview(Composite composite, int numColumns) {
        AbstractFormatterSelectionBlock.createLabel(composite, FormatterMessages.AbstractFormatterSelectionBlock_preview, numColumns);
        this.fPreviewViewer = this.createPreview(composite);
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.heightHint = 100;
        this.fPreviewViewer.getControl().setLayoutData((Object)gd);
    }

    protected IScriptFormatterFactory getSelectedExtension() {
        return this.factories[this.selectedFactory];
    }

    protected final void updateSelection() {
        IProfile selected = this.getProfileManager().getSortedProfiles().get(this.fProfileCombo.getSelectionIndex());
        this.getProfileManager().setSelected(selected);
        this.updateButtons();
        this.applyPreferences();
        this.updatePreview();
    }

    protected void editButtonPressed() {
        IScriptFormatterFactory factory = this.getSelectedExtension();
        if (factory != null) {
            IProfileManager manager = this.getProfileManager();
            IFormatterModifyDialog dialog = factory.createDialog(this.createDialogOwner());
            if (dialog != null) {
                dialog.setProfileManager(manager);
                IProfile profile = manager.getSelected();
                dialog.setPreferences(profile.getSettings());
                if (dialog.open() == 0) {
                    profile = manager.getSelected();
                    this.updateComboFromProfiles();
                    Map<String, String> newSettings = dialog.getPreferences();
                    if (!profile.getSettings().equals(newSettings)) {
                        profile.setSettings(newSettings);
                        manager.markDirty();
                        this.applyPreferences();
                    }
                }
            }
        }
    }

    protected void updateComboFromProfiles() {
        if (this.fProfileCombo != null && !this.fProfileCombo.isDisposed()) {
            this.fProfileCombo.removeAll();
            List<IProfile> profiles = this.getProfileManager().getSortedProfiles();
            IProfile selected = this.getProfileManager().getSelected();
            int selection = 0;
            int index = 0;
            for (IProfile profile : profiles) {
                this.fProfileCombo.add(profile.getName());
                if (profile.equals(selected)) {
                    selection = index;
                }
                ++index;
            }
            this.fProfileCombo.select(selection);
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        if (this.fDeleteButton != null && !this.fDeleteButton.isDisposed()) {
            IProfile selected = this.getProfileManager().getSelected();
            this.fDeleteButton.setEnabled(!selected.isBuiltInProfile());
        }
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected static Label createLabel(Composite composite, String text, int numColumns) {
        return AbstractFormatterSelectionBlock.createLabel(composite, text, numColumns, false);
    }

    protected static Label createLabel(Composite composite, String text, int numColumns, boolean wrap) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        if (wrap) {
            gd.heightHint = new PixelConverter((Control)composite).convertHeightInCharsToPixels(2);
        }
        Label label = new Label(composite, wrap ? 64 : 0);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private boolean hasValidId(String id) {
        return id != null && !"".equals(id);
    }

    private class LoadDelegate
    implements IPreferencesLookupDelegate {
        private LoadDelegate() {
        }

        public boolean getBoolean(String qualifier, String key) {
            return AbstractFormatterSelectionBlock.this.getBooleanValue(new PreferenceKey(qualifier, key));
        }

        public int getInt(String qualifier, String key) {
            return AbstractFormatterSelectionBlock.this.getIntValue(new PreferenceKey(qualifier, key));
        }

        public String getString(String qualifier, String key) {
            return AbstractFormatterSelectionBlock.this.getValue(new PreferenceKey(qualifier, key));
        }
    }

    private class SaveDelegate
    implements IPreferencesSaveDelegate {
        private SaveDelegate() {
        }

        public void setBoolean(String qualifier, String key, boolean value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), value);
        }

        public void setInt(String qualifier, String key, int value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), String.valueOf(value));
        }

        public void setString(String qualifier, String key, String value) {
            AbstractFormatterSelectionBlock.this.setValue(new PreferenceKey(qualifier, key), value);
        }
    }
}

