/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.internal.ui.text.hover.SourceViewerInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class ScriptSourceHover
extends AbstractScriptEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    @Override
    protected String getHoverInfo(String nature, IModelElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IModelElement curr = result[0];
        if (curr instanceof IMember && curr instanceof ISourceReference) {
            String[] sourceLines;
            String source;
            block7: {
                block6: {
                    try {
                        source = ((ISourceReference)curr).getSource();
                        if (source != null) break block6;
                        return null;
                    }
                    catch (ModelException modelException) {}
                }
                sourceLines = Strings.convertIntoLines(source);
                if (sourceLines != null) break block7;
                return null;
            }
            String delim = System.getProperty("line.separator", "\n");
            source = Strings.concatenate(sourceLines, delim);
            return source;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                IEditorPart editor = ScriptSourceHover.this.getEditor();
                if (editor instanceof ScriptEditor) {
                    int shellStyle = 12;
                    if (editor instanceof IWorkbenchPartOrientation) {
                        shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                    }
                    return new SourceViewerInformationControl(parent, shellStyle, 0, EditorsUI.getTooltipAffordanceString(), ((ScriptEditor)editor).getLanguageToolkit());
                }
                return null;
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 768;
                int shellStyle = 20;
                IEditorPart editor = ScriptSourceHover.this.getEditor();
                if (editor instanceof IWorkbenchPartOrientation) {
                    shellStyle |= ((IWorkbenchPartOrientation)editor).getOrientation();
                }
                if (editor instanceof ScriptEditor) {
                    return new SourceViewerInformationControl(parent, shellStyle, style, ((ScriptEditor)editor).getLanguageToolkit());
                }
                return null;
            }
        };
    }
}

