/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.javascript.parser.JSLexer;
import org.eclipse.dltk.javascript.parser.JavaScriptParserProblems;
import org.eclipse.dltk.javascript.parser.NoIdentifierException;
import org.eclipse.dltk.javascript.parser.Reporter;

public class JavaScriptLexer
extends JSLexer {
    private Reporter reporter;
    private int lastRecoveryIndex = -1;

    public JavaScriptLexer(CharStream input) {
        super(input);
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void recover(RecognitionException re) {
        if (re instanceof MismatchedTokenException) {
            if (re.index <= this.lastRecoveryIndex) {
                return;
            }
            this.lastRecoveryIndex = re.index;
        }
        super.recover(re);
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        int end;
        int start;
        if (this.reporter == null) {
            return;
        }
        if (e instanceof NoIdentifierException) {
            e.c = this.input.LA(1);
            start = this.input.index();
            end = start + 1;
        } else {
            start = this.lastToken != null ? this.reporter.getOffset(this.lastToken) + this.reporter.length(this.lastToken) : 0;
            end = this.reporter.getOffset(e.line, e.charPositionInLine);
            if (end < start) {
                end = start + 1;
            }
        }
        String msg = this.getErrorMessage(e, tokenNames);
        this.reporter.setMessage(JavaScriptParserProblems.LEXER_ERROR, msg);
        this.reporter.setSeverity(ProblemSeverity.ERROR);
        this.reporter.setRange(start, end);
        this.reporter.setLine(e.line - 1);
        this.reporter.report();
    }

    public String getCharErrorDisplay(int c) {
        String s = super.getCharErrorDisplay(c);
        if (c >= 32 && c < 127) {
            return s;
        }
        return String.valueOf(s) + " (0x" + Integer.toHexString(c).toUpperCase() + ")";
    }

    public void recoverFromMismatchedToken(IntStream input, RecognitionException e, int ttype, BitSet follow) throws RecognitionException {
        if (input.LA(2) == ttype) {
            this.reportError(e);
            this.beginResync();
            input.consume();
            this.endResync();
            input.consume();
            return;
        }
        if (!this.recoverFromMismatchedElement(input, e, follow)) {
            throw e;
        }
    }
}

