/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDragAdapter;
import org.eclipse.dltk.internal.ui.dnd.EditorInputTransferDragAdapter;
import org.eclipse.dltk.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDragAdapter;
import org.eclipse.dltk.internal.ui.search.ColorDecoratingLabelProvider;
import org.eclipse.dltk.internal.ui.search.DLTKSearchContentProvider;
import org.eclipse.dltk.internal.ui.search.DLTKSearchEditorOpener;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.internal.ui.search.DLTKSearchTableContentProvider;
import org.eclipse.dltk.internal.ui.search.GroupAction;
import org.eclipse.dltk.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.dltk.internal.ui.search.NewSearchViewActionGroup;
import org.eclipse.dltk.internal.ui.search.PostfixLabelProvider;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.internal.ui.search.SortAction;
import org.eclipse.dltk.internal.ui.search.SortingLabelProvider;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.search.IMatchPresentation;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.viewsupport.ProblemTableViewer;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;

public class DLTKSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String KEY_GROUPING = "org.eclipse.dltk.search.resultpage.grouping";
    private static final String KEY_SORTING = "org.eclipse.dltk.search.resultpage.sorting";
    private static final String KEY_LIMIT_ENABLED = "org.eclipse.dltk.search.resultpage.limit_enabled";
    private static final String KEY_LIMIT = "org.eclipse.dltk.search.resultpage.limit";
    private static final String GROUP_GROUPING = "org.eclipse.dltk.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "org.eclipse.dltk.search.resultpage.filtering";
    private NewSearchViewActionGroup fActionGroup;
    private DLTKSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByParentName;
    private SortAction fSortByPathAction;
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupPackageAction;
    private GroupAction fGroupProjectAction;
    private int fCurrentGrouping;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.dltk.ui.ScriptExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private DLTKSearchEditorOpener fEditorOpener = new DLTKSearchEditorOpener();

    public DLTKSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.setElementLimit(1000);
    }

    private void initSortActions() {
        this.fSortByNameAction = new SortAction(SearchMessages.DLTKSearchResultPage_sortByName, this, 1);
        this.fSortByPathAction = new SortAction(SearchMessages.DLTKSearchResultPage_sortByPath, this, 3);
        this.fSortByParentName = new SortAction(SearchMessages.DLTKSearchResultPage_sortByParentName, this, 2);
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(SearchMessages.DLTKSearchResultPage_groupby_project, SearchMessages.DLTKSearchResultPage_groupby_project_tooltip, this, 4);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "prj_mode.png");
        this.fGroupPackageAction = new GroupAction(SearchMessages.DLTKSearchResultPage_groupby_package, SearchMessages.DLTKSearchResultPage_groupby_package_tooltip, this, 3);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this.fGroupPackageAction, "package_mode.png");
        this.fGroupFileAction = new GroupAction(SearchMessages.DLTKSearchResultPage_groupby_file, SearchMessages.DLTKSearchResultPage_groupby_file_tooltip, this, 2);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "file_mode.png");
        this.fGroupTypeAction = new GroupAction(SearchMessages.DLTKSearchResultPage_groupby_type, SearchMessages.DLTKSearchResultPage_groupby_type_tooltip, this, 1);
        DLTKPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "type_mode.png");
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewSearchViewActionGroup((IViewPart)part);
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor;
        try {
            editor = this.fEditorOpener.openMatch(match);
        }
        catch (ModelException e) {
            throw new PartInitException(e.getStatus());
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                this.showWithMarker(editor, file, offset, length);
            }
        } else {
            DLTKSearchResult result = (DLTKSearchResult)this.getInput();
            IMatchPresentation participant = result.getSearchParticpant(element);
            if (participant != null) {
                participant.showMatch(match, offset, length, activate);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", offset);
            attributes.put("charEnd", offset + length);
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(SearchMessages.DLTKSearchResultPage_error_marker, (Throwable)e);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.DLTKSearchResultPage_sortBylabel);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        sortMenu.add((IAction)this.fSortByParentName);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        this.fSortByParentName.setChecked(this.fCurrentSortOrder == this.fSortByParentName.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.dltk.search.resultpage.grouping"));
        mgr.appendToGroup("org.eclipse.dltk.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        mgr.appendToGroup("org.eclipse.dltk.search.resultpage.grouping", (IAction)this.fGroupPackageAction);
        mgr.appendToGroup("org.eclipse.dltk.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        mgr.appendToGroup("org.eclipse.dltk.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 4);
        this.fGroupPackageAction.setChecked(this.fCurrentGrouping == 3);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 2);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 1);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance()};
        int ops = 5;
        DLTKViewerDragAdapter dragAdapter = new DLTKViewerDragAdapter(viewer);
        dragAdapter.addDragSourceListener(new SelectionTransferDragAdapter((ISelectionProvider)viewer));
        dragAdapter.addDragSourceListener(new EditorInputTransferDragAdapter((ISelectionProvider)viewer));
        dragAdapter.addDragSourceListener(new ResourceTransferDragAdapter((ISelectionProvider)viewer));
        viewer.addDragSupport(ops, transfers, (DragSourceListener)dragAdapter);
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        SortingLabelProvider sortingLabelProvider = new SortingLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider(sortingLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new DLTKSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(sortingLabelProvider));
        this.setSortOrder(this.fCurrentSortOrder);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        PostfixLabelProvider postfixLabelProvider = new PostfixLabelProvider(this);
        viewer.setUseHashlookup(true);
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(postfixLabelProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider(postfixLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new LevelTreeContentProvider(this, this.fCurrentGrouping);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new ProblemTreeViewer(parent, 770);
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new ProblemTableViewer(parent, 770);
    }

    void setSortOrder(int order) {
        this.fCurrentSortOrder = order;
        StructuredViewer viewer = this.getViewer();
        viewer.getControl().setRedraw(false);
        DecoratingLabelProvider dlp = (DecoratingLabelProvider)viewer.getLabelProvider();
        ((SortingLabelProvider)dlp.getLabelProvider()).setOrder(order);
        viewer.getControl().setRedraw(true);
        viewer.refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        this.fActionGroup.fillActionBars(site.getActionBars());
        menuManager.appendToGroup("group.properties", (IAction)new Action(SearchMessages.DLTKSearchResultPage_preferences_label){

            public void run() {
                String pageId = "org.eclipse.search.preferences.SearchPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)pageId, null, null).open();
            }
        });
    }

    void setGrouping(int grouping) {
        this.fCurrentGrouping = grouping;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.dltk.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = 1;
        }
        try {
            this.fCurrentGrouping = this.getSettings().getInt("org.eclipse.dltk.search.resultpage.grouping");
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentGrouping = 3;
        }
        int elementLimit = 1000;
        if (FALSE.equals(this.getSettings().get(KEY_LIMIT_ENABLED))) {
            elementLimit = -1;
        } else {
            try {
                elementLimit = this.getSettings().getInt(KEY_LIMIT);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (memento != null) {
            Integer value = memento.getInteger("org.eclipse.dltk.search.resultpage.grouping");
            if (value != null) {
                this.fCurrentGrouping = value;
            }
            if ((value = memento.getInteger(KEY_SORTING)) != null) {
                this.fCurrentSortOrder = value;
            }
            boolean limitElements = !FALSE.equals(memento.getString(KEY_LIMIT_ENABLED));
            value = memento.getInteger(KEY_LIMIT);
            if (value != null) {
                elementLimit = limitElements ? value : -1;
            }
        }
        this.setElementLimit(elementLimit);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger("org.eclipse.dltk.search.resultpage.grouping", this.fCurrentGrouping);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        int limit = this.getElementLimit();
        if (limit != -1) {
            memento.putString(KEY_LIMIT_ENABLED, TRUE);
        } else {
            memento.putString(KEY_LIMIT_ENABLED, FALSE);
        }
        memento.putInteger(KEY_LIMIT, this.getElementLimit().intValue());
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    public String getLabel() {
        String label = super.getLabel();
        AbstractTextSearchResult input = this.getInput();
        if (input != null && input.getActiveMatchFilters() != null && input.getActiveMatchFilters().length > 0) {
            if (this.isQueryRunning()) {
                String message = SearchMessages.DLTKSearchResultPage_filtered_message;
                return Messages.format(message, new Object[]{label});
            }
            int filteredOut = input.getMatchCount() - this.getFilteredMatchCount();
            String message = SearchMessages.DLTKSearchResultPage_filteredWithCount_message;
            return Messages.format(message, new Object[]{label, String.valueOf(filteredOut)});
        }
        return label;
    }

    private int getFilteredMatchCount() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider tp = (ITreeContentProvider)viewer.getContentProvider();
            return this.getMatchCount(tp, this.getRootElements((TreeViewer)this.getViewer()));
        }
        return this.getMatchCount((TableViewer)viewer);
    }

    private Object[] getRootElements(TreeViewer viewer) {
        Tree t = viewer.getTree();
        TreeItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private Object[] getRootElements(TableViewer viewer) {
        Table t = viewer.getTable();
        TableItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private int getMatchCount(ITreeContentProvider cp, Object[] elements) {
        int count = 0;
        int j = 0;
        while (j < elements.length) {
            count += this.getDisplayedMatchCount(elements[j]);
            Object[] children = cp.getChildren(elements[j]);
            count += this.getMatchCount(cp, children);
            ++j;
        }
        return count;
    }

    private int getMatchCount(TableViewer viewer) {
        Object[] elements = this.getRootElements(viewer);
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            count += this.getDisplayedMatchCount(elements[i]);
            ++i;
        }
        return count;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return (T)SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof ISourceModule || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.openElement(firstElement);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), SearchMessages.DLTKSearchResultPage_open_editor_error_title, SearchMessages.DLTKSearchResultPage_open_editor_error_message);
            }
            return;
        }
        super.handleOpen(event);
    }

    public void setElementLimit(Integer elementLimit) {
        super.setElementLimit(elementLimit);
        int limit = elementLimit;
        this.getSettings().put(KEY_LIMIT, limit);
        this.getSettings().put(KEY_LIMIT_ENABLED, limit != -1 ? TRUE : FALSE);
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerSorter {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            super(null);
            this.fLabelProvider = labelProvider;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

